//	newmtn_view.java
import java.io.*;
import java.awt.*;
import java.awt.event.*;

/*
 *
 */
public class newmtn_view extends Frame implements WindowListener,
	ActionListener, ItemListener, AdjustmentListener, Runnable {

	final int MAX_MTN_COUNT = 8;
	final String FILE_NAME = "Newmtn.oda";
	final int MAX_FRAMES = 312;

	MenuBar mb = new MenuBar();
	Menu exMenu, helpMenu;
	MenuItem file_openItem, exitItem;

	Choice mtnChoice;
	int mtn_count;
	int mtn_type;
	int mtn_frame;
	int mtn_add;
	int show_frame;

	omtn_table [] omtn = new omtn_table[MAX_MTN_COUNT];

	RandomAccessFile file_handle;

	SimpleAibo3DView a3d;


	TextField angle_Head_Tilt;				// Head_Tilt
	TextField angle_Head_Pan;				// Head_Pan
	TextField angle_Head_Roll;				// Head_Roll

	TextField angle_Mouth;					// Mouth

	TextField angle_RFLeg_1;				// RFLeg_1
	TextField angle_RFLeg_2;				// RFLeg_2
	TextField angle_RFLeg_3;				// RFLeg_3

	TextField angle_LFLeg_1;				// LFLeg_1
	TextField angle_LFLeg_2;				// LFLeg_2
	TextField angle_LFLeg_3;				// LFLeg_3

	TextField angle_RRLeg_1;				// RRLeg_1
	TextField angle_RRLeg_2;				// RRLeg_2
	TextField angle_RRLeg_3;				// RRLeg_3

	TextField angle_LRLeg_1;				// LRLeg_1
	TextField angle_LRLeg_2;				// LRLeg_2
	TextField angle_LRLeg_3;				// LRLeg_3

	TextField angle_Head_ON;				// Head_ON
	TextField angle_Head_OFF;				// Head_OFF
	TextField angle_Head_Pat;				// Head_Pat

	TextField angle_Tail_Pan;				// Tail_Pan
	TextField angle_Tail_Tilt;				// Tail_Tilt


	TextField frames;
	Scrollbar frame_ctrlSB;
	Button startB;
	Button stopB;

	TextArea log;

	boolean report_stop = true;
//
	public newmtn_view() {
		super("New MTN ODA Viewer Ver. 0.01");
		addWindowListener(this);

		exMenu = new Menu("File");
		exMenu.add(file_openItem = new MenuItem("Open"));
		exMenu.addSeparator();
		exMenu.add(exitItem = new MenuItem("Exit"));

		helpMenu = new Menu("Help");

		mb.add(exMenu);
		mb.add(helpMenu);
		setMenuBar(mb);

		file_openItem.addActionListener(this);
		exitItem.addActionListener(this);

		mtnChoice = new Choice(); 
		// `CXڂ̐ݒ 
		// Ƃ肠Ao^

		mtnChoice.addItemListener(this); 


		a3d = new SimpleAibo3DView();
		a3d.setSize(240,240);
		a3d.setForeground(Color.yellow); 
		a3d.setBackground(Color.black);


		Panel centerP = new Panel();
		centerP.setLayout(new GridLayout(9,1));
		centerP.add(new Label("Head"));
		centerP.add(angle_Head_Tilt = new TextField("0", 4));		// Head_Tilt
		centerP.add(angle_Head_Pan = new TextField("0", 4));		// Head_Pan
		centerP.add(angle_Head_Roll = new TextField("0", 4));		// Head_Roll
		centerP.add(new Label("Mouth"));
		centerP.add(angle_Mouth = new TextField("0", 4));			// Mouth
		centerP.add(new Label("Tail"));
		centerP.add(angle_Tail_Pan = new TextField("0", 4));		// Tail_Pan
		centerP.add(angle_Tail_Tilt = new TextField("0", 4));		// Tail_Tilt
		angle_Head_Tilt.setEditable(false);
		angle_Head_Pan.setEditable(false);
		angle_Head_Roll.setEditable(false);
		angle_Mouth.setEditable(false);
		angle_Tail_Pan.setEditable(false);
		angle_Tail_Tilt.setEditable(false);

		Panel rflegP = new Panel();
		rflegP.setLayout(new GridLayout(4,1));
		rflegP.add(new Label("RFLeg"));
		rflegP.add(angle_RFLeg_1 = new TextField("0", 4));			// RFLeg_1
		rflegP.add(angle_RFLeg_2 = new TextField("0", 4));			// RFLeg_2
		rflegP.add(angle_RFLeg_3 = new TextField("0", 4));			// RFLeg_3
		angle_RFLeg_1.setEditable(false);
		angle_RFLeg_2.setEditable(false);
		angle_RFLeg_3.setEditable(false);

		Panel lflegP = new Panel();
		lflegP.setLayout(new GridLayout(4,1));
		lflegP.add(new Label("LFLeg"));
		lflegP.add(angle_LFLeg_1 = new TextField("0", 4));			// LFLeg_1
		lflegP.add(angle_LFLeg_2 = new TextField("0", 4));			// LFLeg_2
		lflegP.add(angle_LFLeg_3 = new TextField("0", 4));			// LFLeg_3
		angle_LFLeg_1.setEditable(false);
		angle_LFLeg_2.setEditable(false);
		angle_LFLeg_3.setEditable(false);

		Panel rrlegP = new Panel();
		rrlegP.setLayout(new GridLayout(4,1));
		rrlegP.add(new Label("RRLeg"));
		rrlegP.add(angle_RRLeg_1 = new TextField("0", 4));			// RRLeg_1
		rrlegP.add(angle_RRLeg_2 = new TextField("0", 4));			// RRLeg_2
		rrlegP.add(angle_RRLeg_3 = new TextField("0", 4));			// RRLeg_3
		angle_RRLeg_1.setEditable(false);
		angle_RRLeg_2.setEditable(false);
		angle_RRLeg_3.setEditable(false);

		Panel lrlegP = new Panel();
		lrlegP.setLayout(new GridLayout(4,1));
		lrlegP.add(new Label("LRLeg"));
		lrlegP.add(angle_LRLeg_1 = new TextField("0", 4));			// LRLeg_1
		lrlegP.add(angle_LRLeg_2 = new TextField("0", 4));			// LRLeg_2
		lrlegP.add(angle_LRLeg_3 = new TextField("0", 4));			// LRLeg_3
		angle_LRLeg_1.setEditable(false);
		angle_LRLeg_2.setEditable(false);
		angle_LRLeg_3.setEditable(false);

		Panel rlegP = new Panel();
		rlegP.setLayout(new GridLayout(2,1));
		rlegP.add(rflegP);
		rlegP.add(rrlegP);

		Panel llegP = new Panel();
		llegP.setLayout(new GridLayout(2,1));
		llegP.add(lflegP);
		llegP.add(lrlegP);

		Panel angleP = new Panel();
		angleP.setLayout(new GridLayout(1,3));
		angleP.add(llegP);
		angleP.add(centerP);
		angleP.add(rlegP);

		Panel frame_countP = new Panel();
		frame_countP.setLayout(new GridLayout(1,2));
		frame_countP.add(new Label("Frame : "));
		frame_countP.add(frames = new TextField("0", 6));
		frames.setEditable(false);

		Panel frame_ctrlP = new Panel();
		frame_ctrlP.setLayout(new GridLayout(1,1));
		frame_ctrlP.add(frame_ctrlSB = new Scrollbar(Scrollbar.HORIZONTAL, 0, 1, 0, MAX_FRAMES));

		frame_ctrlSB.addAdjustmentListener(this);

		Panel frameP = new Panel();
		frameP.setLayout(new GridLayout(2,2));
		frameP.add(frame_countP);
		frameP.add(frame_ctrlP);
		frameP.add(startB = new Button("Start"));
		frameP.add(stopB = new Button("Stop"));

		startB.addActionListener(this);
		stopB.addActionListener(this);

		log = new TextArea(10, 90);
		log.setEditable(false);										// log ͕\[hɐݒ 

		setLayout(new BorderLayout());

		add(mtnChoice, "North");
//		add(statusP,"West");
		add(a3d, "Center");
		add(angleP,"East");
		add(frameP, "South");
//
	}
//
	public void frame_start() {
		setSize(400,320);
//		setResizable(false);
		setVisible(true);
	}
//
	public void windowClosing(WindowEvent we) {
		dispose();
		if(file_handle != null) {
			try {
				file_handle.close(); 
			} catch(IOException e){ }
		}
		System.exit(1);
	}
//
	public void windowClosed(WindowEvent we) { }
	public void windowOpened(WindowEvent we) { }
	public void windowIconified(WindowEvent we) { }
	public void windowDeiconified(WindowEvent we) { }
	public void windowActivated(WindowEvent we) { }
	public void windowDeactivated(WindowEvent we) { }
//
	public int get_int_data() {
		int data = 0;

		for(int i = 0; i < 4; i++) {
			try {
				data |= (file_handle.readByte() & 0xFF) << (i * 8); 
			} catch(IOException e){ }
		}
		return data;
	}
//
	public void add_motion_list() {
		String name;
		int add;
		int size;
		int i, j;
		char c;
		long file_pointer;

		file_pointer = 8;
		try {
			file_handle.seek(file_pointer); 
		} catch(IOException e){ }
		mtn_count = get_int_data();									// [Vo^̎擾
		if(mtn_count > MAX_MTN_COUNT) {
			mtn_count = MAX_MTN_COUNT;
		}
		file_pointer = 64;
		for(i = 0; i < mtn_count; i++) {
			file_pointer += 4;
			name = "";
			add = 0;
			size = 0;
			try {
				file_handle.seek(file_pointer); 
			} catch(IOException e){ }
			for(j = 0; j < 128; j++) {
				try {
					if((c = (char)file_handle.readByte()) != 0) {
						name += String.valueOf(c);					// [V̎擾
					}
				} catch(IOException e){ }
			}
			add = get_int_data();									// X^[gAhX̎擾
			size  = get_int_data();									// [VTCY̎擾
			omtn[i] = new omtn_table(name, add, size);
			mtnChoice.addItem(name);
			file_pointer += 140;
//			System.out.println(omtn[i].get_name() + ": " + omtn[i].get_add() + ", " + omtn[i].get_size());
		}
	}
//
	void set_mtn_add(int index) {
		int add;

		mtn_add = omtn[index].get_add();
		view_motion_data(mtn_add);
		add = get_show_frame_point_address(mtn_add, show_frame, mtn_type);
		view_motion_one_frame(add, mtn_type);

		a3d.repaint();

	}
//
	public void file_open() {
		if(file_handle != null) {
			try {
				file_handle.close();
			} catch(IOException e){ }
			file_handle = null;
		}
		FileDialog lfd = new FileDialog(this, "OPEN", FileDialog.LOAD); 
		lfd.setVisible(true); 
		if(lfd.getFile() != null) {
			mtnChoice.removeAll();
			log.setText("");
			try {
				file_handle = new RandomAccessFile(lfd.getDirectory() + lfd.getFile(),"r"); 
			} catch(IOException e){ }
			if(FILE_NAME.equals(lfd.getFile())) {
				add_motion_list();
				set_mtn_add(0);
//				System.out.println("" + mtnChoice.getSelectedIndex());
			} else {
				try {
					file_handle.close(); 
				} catch(IOException e){ }
			}
		}
	}
//
	public void actionPerformed(ActionEvent ae) {
		if(file_openItem.equals(ae.getSource())) {
			file_open();
		} else if(exitItem.equals(ae.getSource())) {
			if(file_handle != null) {
				try {
					file_handle.close(); 
				} catch(IOException e){ }
			}
			System.exit(0);
		} else if(startB.equals(ae.getSource())) {
			report_stop = false;
		} else if(stopB.equals(ae.getSource())) {
			report_stop = true;
		} else {
			;
		}
	}
//
	public void set_angle_data(int [] data, int type) {
		int shift = 0;

		if(type == 1) {												// ERS-31x
			a3d.angleHead_Tilt1 = data[0];
			a3d.angleHead_Tilt2 = data[1];
			a3d.angleHead_Pan = data[2];
			shift = 3;
		} else {
			a3d.angleHead_Tilt1 = 0;
			a3d.angleHead_Tilt2 = 0;
			a3d.angleHead_Pan = 0;
		}
		a3d.angleMouth = 0;
		a3d.angleLFLeg_1 = data[0 + shift];
		a3d.angleLFLeg_2 = data[1 + shift];
		a3d.angleLFLeg_3 = data[2 + shift];
		a3d.angleRFLeg_1 = data[3 + shift];
		a3d.angleRFLeg_2 = data[4 + shift];
		a3d.angleRFLeg_3 = data[5 + shift];
		a3d.angleLRLeg_1 = data[6 + shift];
		a3d.angleLRLeg_2 = data[7 + shift];
		a3d.angleLRLeg_3 = data[8 + shift];
		a3d.angleRRLeg_1 = data[9 + shift];
		a3d.angleRRLeg_2 = data[10 + shift];
		a3d.angleRRLeg_3 = data[11 + shift];
		if(type == 2) {												// ERS-210
			a3d.angleTail_Pan = data[12];
			a3d.angleTail_Tilt = data[13];
		} else {
			a3d.angleTail_Pan = 0;
			a3d.angleTail_Tilt = 0;
		}
	}
//
	public void show_angle_data(int [] data, int type) {
		int shift = 0;

		if(type == 1) {												// ERS-31x
			angle_Head_Tilt.setText("" + data[0]);					// Head_Tilt1
			angle_Head_Pan.setText("" + data[1]);					// Head_Tilt2
			angle_Head_Roll.setText("" + data[2]);					// Head_Pan
		} else {
			angle_Head_Tilt.setText("0");							// Head_Tilt
			angle_Head_Pan.setText("0");							// Head_Pan
			angle_Head_Roll.setText("0");							// Head_Roll
		}
		angle_Mouth.setText("0");									// Mouth

		if(type == 1) {												// ERS-31x
			shift = 3;
		}
		angle_LFLeg_1.setText("" + data[0 + shift]);				// LFLeg_1
		angle_LFLeg_2.setText("" + data[1 + shift]);				// LFLeg_2
		angle_LFLeg_3.setText("" + data[2 + shift]);				// LFLeg_3
		angle_RFLeg_1.setText("" + data[3 + shift]);				// RFLeg_1
		angle_RFLeg_2.setText("" + data[4 + shift]);				// RFLeg_2
		angle_RFLeg_3.setText("" + data[5 + shift]);				// RFLeg_3
		angle_LRLeg_1.setText("" + data[6 + shift]);				// LRLeg_1
		angle_LRLeg_2.setText("" + data[7 + shift]);				// LRLeg_2
		angle_LRLeg_3.setText("" + data[8 + shift]);				// LRLeg_3
		angle_RRLeg_1.setText("" + data[9 + shift]);				// RRLeg_1
		angle_RRLeg_2.setText("" + data[10 + shift]);				// RRLeg_2
		angle_RRLeg_3.setText("" + data[11 + shift]);				// RRLeg_3

		if(type == 2) {												// ERS-210
			angle_Tail_Pan.setText("" + data[12]);					// Tail_Pan
			angle_Tail_Tilt.setText("" + data[13]);					// Tail_Tilt
		}
	}

	int get_joints(int type) {
		int joints;

		switch(type) {
			case 1 :												// ERS-31xp
				joints = 15;
				break;
			case 2 :												// ERS-210p
				joints = 14;
				break;
			case 3 :												// ERS-220p
				joints = 12;
				break;
			default :
				joints = 15;
				break;
		}
		return(joints);
	}

//
	public void view_motion_data(int add) {
		long file_pointer = add;
		int i, j;
		String str = "";
		int joint = 15;
		int [] data = new int [joint];

		log.setText("");
		show_frame = 0;
		frames.setText("" + show_frame);
		frame_ctrlSB.setValue(show_frame);
		report_stop = true;

		try {
			file_handle.seek(file_pointer);
		} catch(IOException e){ }
		mtn_type = get_int_data();									// [V^Cv̎擾
		mtn_frame = get_int_data();									// [Vt[o^̎擾

//		joint = get_joints(mtn_type);

//		for(i = 0; i < mtn_frame; i++) {
//			for(j = 0, str = ""; j < joint; j++) {
//				data[j] = get_int_data() * 180 / 3141593;
//				str += "\t" + String.valueOf(data[j]);
//			}
//			System.out.println("" + i + str);
//			log.append("" + i + str + "\n");
//			show_angle_data(data, mtn_type);
//			set_angle_data(data, type);
//			a3d.repaint();

//		}
	}
//
	void view_motion_one_frame(int add, int type) {
		long file_pointer = add;
		int i;
		int joint = 15;
		int [] data = new int [joint];

		try {
			file_handle.seek(file_pointer);
		} catch(IOException e){ }

		joint = get_joints(type);

		for(i = 0; i < joint; i++) {
			data[i] = get_int_data() * 180 / 3141593;
		}
		show_angle_data(data, type);
		set_angle_data(data, type);
	}
//
	public void itemStateChanged(ItemEvent ie) {
//		System.out.println("" + mtnChoice.getSelectedIndex());
		set_mtn_add(mtnChoice.getSelectedIndex());
	}
//
	int get_show_frame_point_address(int start_add, int frames, int type) {
		if(frames >= MAX_FRAMES) {
			frames = MAX_FRAMES - 1;
		}
		return(start_add + 8 + (get_joints(type) * 4) * frames);
	}

// XN[o[̃Cxg 
	public void adjustmentValueChanged(AdjustmentEvent ae) { 
		if(ae.getSource() == frame_ctrlSB) {
			show_frame = ae.getAdjustable().getValue();
			frames.setText("" + show_frame);

			if(mtn_add > 0 && show_frame < mtn_frame) {

				view_motion_one_frame(get_show_frame_point_address(mtn_add, show_frame, mtn_type), mtn_type);
				a3d.repaint();
			}
		}
	}
//
	public void run() {
		int frame = 0;
		int add;

		a3d.repaint();

		while(true) {
			try {
				Thread.sleep(33);
			} catch (InterruptedException e) {}

			if(report_stop) {
				continue;
			}
			if(mtn_add == 0) {
				continue;
			}

			if(show_frame >= mtn_frame) {
				show_frame = mtn_frame - 1;
				report_stop = true;
			}

			frames.setText("" + show_frame);
			frame_ctrlSB.setValue(show_frame);

			add = get_show_frame_point_address(mtn_add, show_frame, mtn_type);
			view_motion_one_frame(add, mtn_type);
//			System.out.println("" + add);
			a3d.repaint();
			show_frame++;
		}
	}

//
	public static void main(String args[]) {
		newmtn_view m = new newmtn_view();
		Thread angle_view = new Thread(m);
		m.frame_start();
		angle_view.start();
	}
}

