//	SimpleAibo3DView.java
import java.awt.*;

/*
 *
 */
class SimpleAibo3DView extends Aibo3DView {
	int angleHead_Tilt1;
	int angleHead_Tilt2;

	public void drawWF_Head(Graphics g, int th1, int th2, int th3, Color co) {
		double x0, y0;
		double [] x = new double[3];
		double [] y = new double[3];
		double [] z = new double[3];

		double a1, a2, a3;
		double sinA1, cosA1;
		double sinA2, cosA2;
		double sinA3, cosA3;

		a1 = (th1) * RAD;
		a2 = (th2 + th1) * RAD;
		a3 = (th3) * RAD;

		sinA1 = Math.sin(a1); cosA1 = Math.cos(a1);
		sinA2 = Math.sin(a2); cosA2 = Math.cos(a2);
		sinA3 = Math.sin(a3); cosA3 = Math.cos(a3);

		x0 = HEAD_PARAMETER[1] * cosA3;
		y0 = HEAD_PARAMETER[1] * sinA3;

		x[0] = HEAD_PARAMETER[2];
		y[0] = HEAD_PARAMETER[3];
		z[0] = HEAD_PARAMETER[4];

		x[1] = HEAD_PARAMETER[2] - HEAD_PARAMETER[0] * sinA1;
		y[1] = HEAD_PARAMETER[3];
		z[1] = HEAD_PARAMETER[4] + HEAD_PARAMETER[0] * cosA1;

		x[2] = x[1] + x0 * cosA2;
		y[2] = y[1] + y0;
		z[2] = z[1] + x0 * sinA2;

		drawWF(g, x, y, z, 120, 100, co);
	}
//
	public void paint(Graphics g) {
		g.drawString("AIBO 3D View", 0, 16);
//		g.drawString("LT : " + (last_time_paint ? "On" : "Off"), getSize().width - 60, 16);
		g.drawString("Tilt=" + angX % 360 + " Pan=" + angY % 360, 0, getSize().height - 10);

		drawWF_Leg(g, 0, angleRFLeg_1, angleRFLeg_2, angleRFLeg_3, col[1]);
		drawWF_Leg(g, 1, angleLFLeg_1, angleLFLeg_2, angleLFLeg_3, col[2]);
		drawWF_Leg(g, 2, angleRRLeg_1, angleRRLeg_2, angleRRLeg_3, col[3]);
		drawWF_Leg(g, 3, angleLRLeg_1, angleLRLeg_2, angleLRLeg_3, col[4]);
		drawWF_Tail(g, angleTail_Pan, angleTail_Tilt, col[5]);
		drawWF_Head(g, angleHead_Tilt1, angleHead_Tilt2, angleHead_Pan, col[6]);
		drawWF_Body(g);
	}
}