//	Cmd.java
import java.io.*;
import java.awt.*;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;

/*
 *
 */
public class Cmd extends Frame implements WindowListener, ActionListener, ItemListener, AdjustmentListener, Runnable {
	MenuBar mb = new MenuBar();

	Menu exMenu, monitorMenu, scanMenu, optionMenu, helpMenu;
	MenuItem saveItem, exitItem;
	MenuItem angle_jointItem, other_system_valueItem;
	MenuItem frontScanItem, globalScanItem;
	Menu ledMenu;
	MenuItem ledItem1, ledItem2, ledItem3, ledItem4, ledItemEnd;
	Menu headMenu, headSubMenu1, headSubMenu2;
	MenuItem headSM2Item1, headSM2Item2, headSM2Item3, headSM2Item4, headSM2Item5, headSM2ItemEnd;
	Menu earMenu;
	MenuItem earItem1, earItem2, earItem3, earItemEnd;
	Menu tailMenu;
	MenuItem tailItem1, tailItem2, tailItem3, tailItem4, tailItem5, tailItemEnd;
//
	TextField hostname;
	Button connect;
//
	Button walk_sBy, stand,sit,lie, start_lie;
//
	Button auto_pilot, r_code_load, r_code_run, r_code_stop, r_code_quit;
//
	Checkbox speed_normal, speed_slow;
	CheckboxGroup speed_group; 
	Button walk, stop, back, left, right, l_walk, r_walk, l_back, r_back;
//
	Button heading, headingL, headingR, headMov, headDef;
	TextField headTV, headTH;
	Scrollbar headVS, headHS;
//
	Button l_Turn30, l_Turn90, l_Turn180 , r_Turn30, r_Turn90, r_Turn180;
//
	Button kick, sit_touch, lie_touch;
	TextField h_ang, h_dist;
	Scrollbar h_angHS, h_distVS;
//
	TextField anyCmd;
	Button enter;
//
	List actionlst;
//
	Checkbox cbH1, cbH2, cbH3, cbH4 , cbJ1, cbJ2 , cbB1, cbB2, cbRF1, cbRR1, cbLF1, cbLR1;
	Button ts_all_resetB;
	TextField head_OFFT, jaw_OFFT, back_OFFT , rFLeg_OFFT, lFLeg_OFFT, rRLeg_OFFT, lRLeg_OFFT;

	TextField  batt_restT, batt_tempT, body_tempT, distanceT, pink_ballT, statusT, posture1T;
	Label posture1U;
	Button status_resetB;
//
	TextArea log;

	SimpleCommander sc;
	Angles angle_frame = null;
	ShowOtherSystemValue other_system_value_frame = null;
	ShowDistance frontScan_frame = null;
	ControlerAutoPilot auto_pilot_t = null;

	final String req_VLst1[] = {
		"Head_Traget:%d:%d:%d:%d:%d:\":Head_Tilt:Head_Pan:Head_Roll:Distance:Pink_Ball",
		"RFLeg:%d:%d:%d:%d:%d:\":RFLeg_1:RFLeg_2:RFLeg_3:RFLeg_ON:RFLeg_OFF",
		"LFLeg:%d:%d:%d:%d:%d:\":LFLeg_1:LFLeg_2:LFLeg_3:LFLeg_ON:LFLeg_OFF",
		"RRLeg:%d:%d:%d:%d:%d:\":RRLeg_1:RRLeg_2:RRLeg_3:RRLeg_ON:RRLeg_OFF",
		"LRLeg:%d:%d:%d:%d:%d:\":LRLeg_1:LRLeg_2:LRLeg_3:LRLeg_ON:LRLeg_OFF",
		"Head_Touch:%d:%d:%d:%d:%d:\":Head_ON:Head_OFF:Head_Pat:Head_Hit:Head_LONG",
		"Mouth_Jaw:%d:%d:%d:%d:%d:\":Mouth:Jaw_ON:Jaw_OFF:Jaw_LONG:Batt_Rest",
		"Tail_Back:%d:%d:%d:%d:%d:\":Tail_Pan:Tail_Tilt:Back_ON:Back_OFF:Back_LONG",
		"Batt_Stat:%d:%d:%d:%d:%d:\":Batt_Temp:Body_Temp:Status:Posture1:Posture2",
		"Wait_Clock_OTemp:%d:%d:%d:%d:%d:\":Wait:Clock:IntClock:Temp_Hi:Temp_OK",
		"Tail_Switch1:%d:%d:%d:%d:%d:\":RTail_ON:RTail_OFF:RTail_LONG:CTail_ON:CTail_OFF",
		"Tail_Switch2:%d:%d:%d:%d:\":CTail_LONG:LTail_ON:LTail_OFF:LTail_LONG"
	};

	final String req_VLst2[] = {
		"Date_Other:%d:%d:%d:%d:%d:\":Year:Month:Day:Dow:AiboId",
		"Time_Other:%d:%d:%d:%d:%d:\":Hour:Min:Sec:Seed:Context",
		"Trace_Other:%d:%d:%d:%d:%d:\":Trace:Debug:AutoReset:Power:WaitMode",
		"Category:%d:%d:%d:\":CategoryL:CategoryM:CategoryS"
	};

	boolean request_stop_flag = false;
	boolean speed_mode = false;

	final String p_act = "PLAY:ACTION:";
	final String list_PlayAction[] = {
		"WALK::",													// 
		"TURN:",													// 񂷂
		"KICK::",													// LbN
		"TOUCH::",													// G
		"MOVE_HEAD::",												// w
		"TRACK_HEAD",												// ǐՂ
		"SEARCH",													// T
		"SEARCH.HEAD.NORMAL",										// ĂT
		"SEARCH.HEAD.SLOW",											// ĂT
		"SEARCH.HEAD.NORMALCENT",									// OĒT
		"SEARCH.HEAD.SLOWCENT",										// OĂT
		"SEARCH.HEAD.LOWCENT",										// ĒT
		"MOVE.HEAD.FAST::",											// w𑬂
		"MOVE.HEAD.NORMAL::",										// w
		"MOVE.HEAD.SLOW::",											// w茩
		"MOVE.TURN.NORMAL:",										// 񂷂
		"MOVE.TURN.SLOW:",											// 񂷂
		"MOVE.MOVE.NORMAL::",										// 
		"MOVE.MOVE.SLOW::",											// 
		"CHGPOS.WALK.NORMAL::",										// spɂ
		"CONTACT.RIGHT.TOUCH::",									// ĉEŐG
		"CONTACT.RIGHT.TOUCH2::"									// ĉEŐG
	};
	final String list_MWCID[] = {
		"1358 // AIBOZYA", 
		"1229 // CUTE_ANGRY1",
		"210  // CUTE_BANZAI1",
		"1580 // CUTE_BARK1",
		"1581 // CUTE_BARK2",
		"1582 // CUTE_BARK3",
		"2032 // CUTE_BOXING",
		"1261 // CUTE_BYE1",
		"1262 // CUTE_BYE2",
		"1263 // CUTE_BYE3",
		"217  // CUTE_EXERCISE1",
		"218  // CUTE_EXERCISE2",
		"1548 // CUTE_EXERCISE3",
		"285  // CUTE_EXERCISE4",
		"1343 // CUTE_EXERCISE5",
		"1344 // CUTE_EXERCISE6",
		"1255 // CUTE_JOY1",
		"1256 // CUTE_JOY2",
		"233  // CUTE_SMILE1",
		"1549 // CUTE_STATION_POSTURE1",
		"1268 // CUTE_STATION_POSTURE2",
		"1273 // CUTE_STATION_POSTURE3",
		"1274 // CUTE_STATION_POSTURE4",
		"7220 // CUTE_SWING1",
		"7221 // CUTE_SWING2",
		"2053 // DANCE_SIT1",
		"2054 // DANCE_SIT2",
		"2055 // DANCE_SIT3",
		"240  // DANCE1",
		"241  // DANCE2",
		"242  // DANCE3",
		"243  // DANCE4",
		"244  // DANCE5",
		"245  // DANCE6",
		"246  // DANCE7",
		"1948 // DANCE8",
		"1914 // DANCE9",
		"1359 // FURYOU",
		"2339 // OTOHELL1G    -->    GOTOHELL1",			// GOTOHELL1
		"1381 // HICCUPS",
		"1588 // HUNGRY",
		"2070 // KAMUZO",
		"1289 // KARATE1",
		"1290 // KARATE2",
		"1291 // KARATE3",
		"2328 // KISS1",
		"2329 // KISS2",
		"274  // NOBI1",
		"275  // NOBI2",
		"276  // NOBI3",
		"277  // NOBI4",
		"2337 // OH_MY_GOD1",
		"2338 // OH_MY_GOD2",
		"2346 // OJIGI",
		"1888 // PHOTOSNAP",
		"1293 // PHOTOEND",
		"1292 // PHOTOOK",
		"1295 // POSE1",
		"1296 // POSE2",
		"1297 // POSE3",
		"1298 // POSE4",
		"1299 // POSE5",
		"1955 // SNEEZE",
		"1352 // TEMPER_TANTRUM1",
		"1345 // TEMPER_TANTRUM2",
		"1346 // TEMPER_TANTRUM3",
		"1347 // TEMPER_TANTRUM4",
		"1349 // TEMPER_TANTRUM5",
		"1356 // TEMPER_TANTRUM6",
		"1585 // TEMPER_TANTRUM7",
		"1599 // TEMPER_TANTRUM8",
		"2017 // YUUTOU1",
		"2018 // YUUTOU2",
		"2019 // YUUTOU3",
		"2021 // YUUTOU4"
	};

	public Cmd() {
		super("Cmd Ver. 0.26");
		addWindowListener(this);

		exMenu = new Menu("File");
		exMenu.add(saveItem = new MenuItem("Save"));				// ۑ
		saveItem.setEnabled(false);
		exMenu.addSeparator();
		exMenu.add(exitItem = new MenuItem("Exit"));				// I

		monitorMenu = new Menu("Monitor");
		monitorMenu.add(angle_jointItem = new MenuItem("Angle of Joint"));
		monitorMenu.add(other_system_valueItem = new MenuItem("Other System Value"));

		scanMenu = new Menu("Scanning 3D Space");
		scanMenu.add(frontScanItem = new MenuItem("Front Scan"));
		scanMenu.add(globalScanItem = new MenuItem("Global Scan"));

		optionMenu = new Menu("Option");

		ledMenu = new Menu("LED");									// LED̓_ݒ
		ledMenu.setEnabled(false);
		ledMenu.add(ledItem1 = new MenuItem("Error1"));				// fobNpG[ʒm1
		ledMenu.add(ledItem2 = new MenuItem("Error2"));				// fobNpG[ʒm2
		ledMenu.addSeparator();
		ledMenu.add(ledItem3 = new MenuItem("Notice1"));			// fobOpʒm1
		ledMenu.add(ledItem4 = new MenuItem("Notice2"));			// fobOpʒm2
		ledMenu.addSeparator();
		ledMenu.add(ledItemEnd = new MenuItem("Clear"));			// fobOp\NA
//
		headMenu = new Menu("Head");								// ̐ݒ
		headMenu.setEnabled(false);
			headSubMenu1 = new Menu("Move");						// 
			headSubMenu2 = new Menu("Search/Track");				// TǐՂ
			headSubMenu2.add(headSM2Item1 = new MenuItem("Search"));	// T  ڕWTB
			headSubMenu2.add(headSM2Item2 = new MenuItem("L_Search"));	// ɌȂāAڕWTB
			headSubMenu2.add(headSM2Item3 = new MenuItem("N_Search"));	// ĂAڕWTB
			headSubMenu2.add(headSM2Item4 = new MenuItem("C_Search"));	// OɌȂāAڕWTB
// ĂAڕWTB
// OɌȂāAڕWTB
			headSubMenu2.addSeparator();
			headSubMenu2.add(headSM2Item5 = new MenuItem("Track"));	// ǐՂ
			headSubMenu2.addSeparator();
			headSubMenu2.add(headSM2ItemEnd = new MenuItem("Stop"));
		headMenu.add(headSubMenu1);
		headMenu.add(headSubMenu2);
//
		earMenu = new Menu("Ear");									// 
		earMenu.setEnabled(false);
		earMenu.add(earItem1 = new MenuItem("B_Ear"));				// 𓮂B
		earMenu.add(earItem2 = new MenuItem("L_Ear"));				// 𓮂B
		earMenu.add(earItem3 = new MenuItem("R_Ear"));				// E𓮂B
		earMenu.addSeparator();
		earMenu.add(earItemEnd = new MenuItem("Stop"));				// ̓~߂B
//
		tailMenu = new Menu("Tail");								// K̐ݒ
		tailMenu.setEnabled(false);
		tailMenu.add(tailItem1 = new MenuItem("U_Tail"));			// ۂグB
		tailMenu.add(tailItem2 = new MenuItem("D_Tail"));			// ۂB
		tailMenu.addSeparator();
		tailMenu.add(tailItem3 = new MenuItem("H_Tail"));			// ۂɐUB
		tailMenu.add(tailItem4 = new MenuItem("V_Tail"));			// ۂcɐUB
		tailMenu.addSeparator();
		tailMenu.add(tailItem5 = new MenuItem("R_Tail"));			// ۂ񂷁B
		tailMenu.addSeparator();
		tailMenu.add(tailItemEnd = new MenuItem("Stop"));			// ۂ̓~߂B

		optionMenu.add(ledMenu);
		optionMenu.add(headMenu);
		optionMenu.add(earMenu);
		optionMenu.add(tailMenu);

		helpMenu = new Menu("Help");

		mb.add(exMenu);
		mb.add(monitorMenu);
		mb.add(scanMenu);
		mb.add(optionMenu);
		mb.add(helpMenu);

		setMenuBar(mb);

		// Xi[̓o^
		exitItem.addActionListener(this);

		angle_jointItem.addActionListener(this);
		other_system_valueItem.addActionListener(this);

		frontScanItem.addActionListener(this);
		globalScanItem.addActionListener(this);

		ledItem1.addActionListener(this);
		ledItem2.addActionListener(this);
		ledItem3.addActionListener(this);
		ledItem4.addActionListener(this);
		ledItemEnd.addActionListener(this);

		headSM2Item1.addActionListener(this);
		headSM2Item2.addActionListener(this);
		headSM2Item3.addActionListener(this);
		headSM2Item4.addActionListener(this);
		headSM2Item5.addActionListener(this);
		headSM2ItemEnd.addActionListener(this);

		earItem1.addActionListener(this);
		earItem2.addActionListener(this);
		earItem3.addActionListener(this);
		earItemEnd.addActionListener(this);

		tailItem1.addActionListener(this);
		tailItem2.addActionListener(this);
		tailItem3.addActionListener(this);
		tailItem4.addActionListener(this);
		tailItem5.addActionListener(this);
		tailItemEnd.addActionListener(this);
//
		setLayout(new BorderLayout());

		Panel connectP = new Panel();
		connectP.setLayout(new GridLayout(1,2));
		connectP.add(hostname = new TextField("aibo",20));
		connectP.add(connect = new Button("Connect"));
//
		Panel ditectHeadP = new Panel();
		ditectHeadP.add(new Label("H"));
		ditectHeadP.add(cbH1 = new Checkbox("O", false));
		ditectHeadP.add(cbH2 = new Checkbox("P", false));
		ditectHeadP.add(cbH3 = new Checkbox("H", false));
		ditectHeadP.add(cbH4 = new Checkbox("L", false));

		Panel ditectJawAndBackP = new Panel();
		ditectJawAndBackP.add(new Label("J"));
		ditectJawAndBackP.add(cbJ1 = new Checkbox("O", false));
		ditectJawAndBackP.add(cbJ2 = new Checkbox("L", false));

		ditectJawAndBackP.add(new Label("B"));
		ditectJawAndBackP.add(cbB1 = new Checkbox("O", false));
		ditectJawAndBackP.add(cbB2 = new Checkbox("L", false));

		Panel ditectRFLegP = new Panel();
		ditectRFLegP.setLayout(new GridLayout(2,1));
		ditectRFLegP.add(new Label("RFLeg"));
		ditectRFLegP.add(cbRF1 = new Checkbox("O", false));

		Panel ditectRRLegP = new Panel();
		ditectRRLegP.setLayout(new GridLayout(2,1));
		ditectRRLegP.add(cbRR1 = new Checkbox("O", false));
		ditectRRLegP.add(new Label("RRLeg"));

		Panel ditectRLegP = new Panel();
		ditectRLegP.setLayout(new GridLayout(2,1));
		ditectRLegP.add(ditectRFLegP);
		ditectRLegP.add(ditectRRLegP);

		Panel ditectLFLegP = new Panel();
		ditectLFLegP.setLayout(new GridLayout(2,1));
		ditectLFLegP.add(new Label("LFLeg"));
		ditectLFLegP.add(cbLF1 = new Checkbox("O", false));

		Panel ditectLRLegP = new Panel();
		ditectLRLegP.setLayout(new GridLayout(2,1));
		ditectLRLegP.add(cbLR1 = new Checkbox("O", false));
		ditectLRLegP.add(new Label("LRLeg"));

		Panel ditectLLegP = new Panel();
		ditectLLegP.setLayout(new GridLayout(2,1));
		ditectLLegP.add(ditectLFLegP);
		ditectLLegP.add(ditectLRLegP);

		Panel off_timeP = new Panel();
		off_timeP.setLayout(new GridLayout(4,2));
		off_timeP.add(head_OFFT = new TextField(6));
		off_timeP.add(ts_all_resetB = new Button("All Rst"));
		off_timeP.add(lFLeg_OFFT = new TextField(6));
		off_timeP.add(rFLeg_OFFT = new TextField(6));
		off_timeP.add(lRLeg_OFFT = new TextField(6));
		off_timeP.add(rRLeg_OFFT = new TextField(6));
		off_timeP.add(jaw_OFFT = new TextField(6));
		off_timeP.add(back_OFFT = new TextField(6));
		head_OFFT.setEditable(false);
		rFLeg_OFFT.setEditable(false);
		lFLeg_OFFT.setEditable(false);
		rRLeg_OFFT.setEditable(false);
		lRLeg_OFFT.setEditable(false);
		jaw_OFFT.setEditable(false);
		back_OFFT.setEditable(false);

		Panel feelP = new Panel();
		feelP.setLayout(new BorderLayout());
		feelP.add(ditectHeadP, BorderLayout.NORTH);
		feelP.add(ditectRLegP, BorderLayout.EAST);
		feelP.add(ditectLLegP, BorderLayout.WEST);
		feelP.add(off_timeP, BorderLayout.CENTER);
		feelP.add(ditectJawAndBackP, BorderLayout.SOUTH);

		Panel conditionLP = new Panel();
		conditionLP.setLayout(new GridLayout(7,1));
		conditionLP.add(new Label("Batt_Rest"));
		conditionLP.add(new Label("Batt_Temp"));
		conditionLP.add(new Label("Body_Temp"));
		conditionLP.add(new Label("Distance"));
		conditionLP.add(new Label("Pink_Ball"));
		conditionLP.add(new Label("Status"));
		conditionLP.add(new Label("Posture1"));

		Panel conditionTP = new Panel();
		conditionTP.setLayout(new GridLayout(7,1));
		conditionTP.add(batt_restT = new TextField(5));
		conditionTP.add(batt_tempT = new TextField(5));
		conditionTP.add(body_tempT = new TextField(5));
		conditionTP.add(distanceT = new TextField(5));
		conditionTP.add(pink_ballT = new TextField(1));
		conditionTP.add(statusT = new TextField(1));
		conditionTP.add(posture1T = new TextField(5));
		batt_restT.setEditable(false);
		batt_tempT.setEditable(false);
		body_tempT.setEditable(false);
		distanceT.setEditable(false);
		pink_ballT.setEditable(false);
		statusT.setEditable(false);
		posture1T.setEditable(false);

		Panel conditionUP = new Panel();
		conditionUP.setLayout(new GridLayout(7,1));
		conditionUP.add(new Label("%"));
		conditionUP.add(new Label("deg."));
		conditionUP.add(new Label("deg."));
		conditionUP.add(new Label("mm"));
		conditionUP.add(new Label(""));
		conditionUP.add(status_resetB = new Button("Reset"));
		conditionUP.add(posture1U = new Label(""));

		Panel conditionP = new Panel();
		conditionP.setLayout(new GridLayout(1,3));
		conditionP.add(conditionLP);
		conditionP.add(conditionTP);
		conditionP.add(conditionUP);

		Panel statusP = new Panel();
		statusP.setLayout(new GridLayout(2,1));
		statusP.add(feelP);
		statusP.add(conditionP);

		Panel styleP = new Panel();
		styleP.setLayout(new GridLayout(5,1));
		styleP.add(walk_sBy = new Button("W Stand by"));
		styleP.add(stand = new Button("Stand"));
		styleP.add(sit = new Button("Sit"));
		styleP.add(lie = new Button("Lie"));
		styleP.add(start_lie = new Button("Start Lie"));

		Panel executeP = new Panel();
		executeP.setLayout(new GridLayout(5,1));
		executeP.add(auto_pilot = new Button("Auto Pilot"));
		executeP.add(r_code_load = new Button("Load"));
		executeP.add(r_code_run = new Button("Run"));
		executeP.add(r_code_stop = new Button("Stop"));
		executeP.add(r_code_quit = new Button("Quit"));

		Panel oprationP = new Panel();
		oprationP.setLayout(new GridLayout(2,1));
		oprationP.add(styleP);
		oprationP.add(executeP);

		Panel walkP = new Panel();
		walkP.setLayout(new GridLayout(3,3));
		walkP.add(l_walk = new Button("L_Walk"));
		walkP.add(walk = new Button("Walk"));
		walkP.add(r_walk = new Button("R_Walk"));
		walkP.add(left = new Button("Left"));
		walkP.add(stop = new Button("W_Stop"));
		walkP.add(right = new Button("Right"));
		walkP.add(l_back = new Button("L_Back"));
		walkP.add(back = new Button("Back"));
		walkP.add(r_back = new Button("R_Back"));
//
		Panel helm1P = new Panel();
		helm1P.setLayout(new GridLayout(1,3));
		helm1P.add(headingL = new Button("L-H"));
		helm1P.add(heading = new Button("H-ing"));
		helm1P.add(headingR = new Button("R-H"));
//
		Panel helm2P = new Panel();
		helm2P.setLayout(new GridLayout(1,3));
		helm2P.add(new Label("Tilt"));
		helm2P.add(new Label("Pan"));
		helm2P.add(headMov = new Button("Move"));
//
		Panel helm3P = new Panel();
		helm3P.setLayout(new GridLayout(1,3));
		helm3P.add(headTV = new TextField("0",3));
		helm3P.add(headTH = new TextField("0",3));
		helm3P.add(headDef = new Button("Def"));
		headTV.setEditable(false);
		headTH.setEditable(false);
//
		Panel helmP = new Panel();
		helmP.setLayout(new GridLayout(3,1));
		helmP.add(helm1P);
		helmP.add(helm2P);
		helmP.add(helm3P);

		Panel headP = new Panel();
		headP.setLayout(new BorderLayout());
		headP.add(headVS = new Scrollbar(Scrollbar.VERTICAL, 0, 1, -23, 69), BorderLayout.WEST);
		headP.add(helmP, BorderLayout.CENTER);
		headP.add(headHS = new Scrollbar(Scrollbar.HORIZONTAL, 0, 1, -68, 69), BorderLayout.SOUTH);

		Panel moveP = new Panel();
		moveP.setLayout(new GridLayout(1,2));
		moveP.add(walkP);
		moveP.add(headP);

		speed_group = new CheckboxGroup();

		Panel turmP = new Panel();
		turmP.setLayout(new GridLayout(4,2));
		turmP.add(speed_normal = new Checkbox("Normal", speed_group, true));
		turmP.add(speed_slow = new Checkbox("Slow", speed_group, false));
		turmP.add(l_Turn30 = new Button("L_Turn30"));
		turmP.add(r_Turn30 = new Button("R_Turn30"));
		turmP.add(l_Turn90 = new Button("L_Turn90"));
		turmP.add(r_Turn90 = new Button("R_Turn90"));
		turmP.add(l_Turn180 = new Button("L_Turn180"));
		turmP.add(r_Turn180 = new Button("R_Turn180"));
//
		Panel handP = new Panel();
		handP.setLayout(new GridLayout(3,3));
		handP.add(new Label(""));
		handP.add(new Label(""));
		handP.add(kick = new Button("Kick"));
		handP.add(new Label("Ang."));
		handP.add(new Label("Dist."));
		handP.add(sit_touch = new Button("Sit_T"));
		handP.add(h_ang = new TextField("0",3));
		handP.add(h_dist = new TextField("0",3));
		handP.add(lie_touch = new Button("Lie_T"));
		h_ang.setEditable(false);

		Panel perforP = new Panel();
		perforP.setLayout(new BorderLayout());
		perforP.add(h_distVS = new Scrollbar(Scrollbar.VERTICAL, 0, 1, -1000, 1), BorderLayout.WEST);
		perforP.add(handP, BorderLayout.CENTER);
		perforP.add(h_angHS = new Scrollbar(Scrollbar.HORIZONTAL, 0, 1, -80, 81), BorderLayout.SOUTH);

		Panel trickP = new Panel();
		trickP.setLayout(new GridLayout(1,2));
		trickP.add(turmP);
		trickP.add(perforP);
//
		Panel anyCmdP = new Panel();
		anyCmdP.add(anyCmd = new TextField(32));
		anyCmdP.add(enter = new Button("Enter"));

		actionlst = new List(2, false);								// PIɐݒ 
		int i;
		for(i = 0; i < list_PlayAction.length; i++) {
			actionlst.add(p_act + list_PlayAction[i]);
		}
		actionlst.add("PLAY:MWCID:701");							// E̓[V
		actionlst.add("PLAY:MWCID:811");							// E̓[V
		actionlst.add("SET:Power:1");
		actionlst.add("SET:Power:0");
		for(i = 0; i < list_MWCID.length; i++) {
			actionlst.add("PLAY:MWCID:" + list_MWCID[i]);
		}
		actionlst.add("@FDIR /MS/OPEN-R/APP/PC/AMS/");
		actionlst.add("@FGET /MS/OPEN-R/APP/PC/AMS/ACTION.AMS");
		actionlst.add("@FGET /MS/OPEN-R/APP/PC/AMS/ACTION.CFG");
		actionlst.add("@FGET /MS/OPEN-R/APP/PC/AMS/R-CODE.R");
		actionlst.add("@FGET /MS/OPEN-R/APP/PC/AMS/ERROR.LOG");
		actionlst.add("@FDEL /MS/OPEN-R/APP/PC/AMS/ERROR.LOG");

		Panel manuarlP = new Panel();
		manuarlP.setLayout(new BorderLayout());
		manuarlP.add(anyCmdP, BorderLayout.NORTH);
		manuarlP.add(actionlst, BorderLayout.CENTER);

		Panel actionP = new Panel();
		actionP.setLayout(new GridLayout(3,1));
		actionP.add(moveP);
		actionP.add(trickP);
		actionP.add(manuarlP);

		Panel buttonP = new Panel();
		buttonP.add(connectP);

		add(buttonP, "North");
		add(statusP,"West");
		add(oprationP,"East");
		add(actionP, "Center");
		add(log = new TextArea(5, 150), "South"); 
		log.setEditable(false);										// log ͕\[hɐݒ 
//
		connect.addActionListener(this);
//
		walk_sBy.addActionListener(this);
		stand.addActionListener(this);
		sit.addActionListener(this);
		lie.addActionListener(this);
		start_lie.addActionListener(this);
//
		auto_pilot.addActionListener(this);
		r_code_load.addActionListener(this);
		r_code_run.addActionListener(this);
		r_code_stop.addActionListener(this);
		r_code_quit.addActionListener(this);
//
		walk.addActionListener(this);
		stop.addActionListener(this);
		back.addActionListener(this);
		left.addActionListener(this);
		right.addActionListener(this);
		l_walk.addActionListener(this);
		r_walk.addActionListener(this);
		l_back.addActionListener(this);
		r_back.addActionListener(this);
//
		headingL.addActionListener(this);
		heading.addActionListener(this);
		headingR.addActionListener(this);
		headVS.addAdjustmentListener(this);
		headHS.addAdjustmentListener(this);
		headMov.addActionListener(this);
		headDef.addActionListener(this);
//
		l_Turn30.addActionListener(this);
		l_Turn90.addActionListener(this);
		l_Turn180.addActionListener(this);
		r_Turn30.addActionListener(this);
		r_Turn90.addActionListener(this);
		r_Turn180.addActionListener(this);
//
		kick.addActionListener(this);
		sit_touch.addActionListener(this);
		lie_touch.addActionListener(this);
		h_angHS.addAdjustmentListener(this);
		h_distVS.addAdjustmentListener(this);
//
		enter.addActionListener(this);
		actionlst.addActionListener(this);

		ts_all_resetB.addActionListener(this);
		status_resetB.addActionListener(this);

		cbH1.addItemListener(this);
		cbH2.addItemListener(this);
		cbH3.addItemListener(this);
		cbH4.addItemListener(this);
		cbJ1.addItemListener(this);
		cbJ2.addItemListener(this);
		cbB1.addItemListener(this);
		cbB2.addItemListener(this);
		cbRF1.addItemListener(this);
		cbRR1.addItemListener(this);
		cbLF1.addItemListener(this);
		cbLR1.addItemListener(this);

		speed_normal.addItemListener(this);
		speed_slow.addItemListener(this);
	}
//
	public void frame_start() {
		setSize(640,440);
		setResizable(false);
		setVisible(true);
		sc = new SimpleCommander();
		sc.set_log_pointer(this);
	}
//
	public void angle_frame_start() {
		angle_frame = new Angles(sc);
		Thread angle_view = new Thread(angle_frame);
		angle_frame.frame_start();
		angle_view.start();
	}
//
	public void other_system_value_frame_start() {
		other_system_value_frame = new ShowOtherSystemValue(sc);
		Thread value_show = new Thread(other_system_value_frame);
		other_system_value_frame.frame_start();
		value_show.start();
	}
//
	public void frontScan_frame_start() {
		frontScan_frame = new ShowDistance(sc);
		Thread distance_show = new Thread(frontScan_frame);
		frontScan_frame.frame_start();
		distance_show.start();
	}
//
	public void end_auto_pilot_mode() {
		if(auto_pilot_t != null) {
			auto_pilot_t.endautopailot();
			auto_pilot_t = null;
			sc.r_code(p_act + "SMESS.ERROR.ERROR2");				// LED_
		}
	}
//
	public void ts_all_reset() {
		sc.r_code("SET:Head_ON:0");									// 
		sc.r_code("SET:Head_Pat:0");								// 
		sc.r_code("SET:Head_Hit:0");								// 
		sc.r_code("SET:Head_LONG:0");								// 
		sc.r_code("SET:Jaw_ON:0");									// 
		sc.r_code("SET:Jaw_LONG:0");								// 
		sc.r_code("SET:Back_ON:0");									// 
		sc.r_code("SET:Back_LONG:0");								// 
		sc.r_code("SET:RFLeg_ON:0");								// 
		sc.r_code("SET:RRLeg_ON:0");								// 
		sc.r_code("SET:LFLeg_ON:0");								// 
		sc.r_code("SET:LRLeg_ON:0");								// 
	}
//
	public void posture1_comment() {
		switch(sc.mem_Posture1) {
			case 1 :
				posture1U.setText("Stand");
				break;
			case 2 :
				posture1U.setText("Sit");
				break;
			case 3 :
				posture1U.setText("Lie");
				break;
			case 4 :
				posture1U.setText("Walk");
				break;
			case 5 :
				posture1U.setText("Station");
				break;
			case 6 :
				posture1U.setText("Lie(2)");
				break;
//			case 7 :
//				posture1U.setText("");
//				break;
//			case 255 :
//				posture1U.setText("");
//				break;
			case 4097 :
				posture1U.setText("Fail_F");
				break;
			case 4098 :
				posture1U.setText("Fail_L");
				break;
			case 4099 :
				posture1U.setText("Fail_R");
				break;
			case 4100 :
				posture1U.setText("Fail_B");
				break;
			case 4101 :
				posture1U.setText("Tumble_D");
				break;
			default :
				posture1U.setText("");
				break;
		}
	}
//
	public void menu_enable(boolean b) {
		ledMenu.setEnabled(b);
		headMenu.setEnabled(b);
		earMenu.setEnabled(b);
		tailMenu.setEnabled(b);
	}
//
	public void walk_control(int angle) {
		if(speed_mode) {
			sc.r_code(p_act + "MOVE.MOVE.SLOW:" + angle + ":-1");	// 
		} else {
			sc.r_code(p_act + "WALK:" + angle + ":-1");				// 
		}
	}
//
	public void turn_control(int angle) {
		if(speed_mode) {
			sc.r_code(p_act + "MOVE.TURN.SLOW:" + angle);			// 񂷂
		} else {
			sc.r_code(p_act + "TURN:" + angle);						// 񂷂
		}
	}
//
	public void windowClosing(WindowEvent we) {
		if("DisConnect" == connect.getLabel()) {
			sc.r_code(p_act + "SMESS.MODE.CLEAR");					// LEDNA
			sc.r_code("QUIT");
			sc.r_code("@DISS");										// ڑ
		}
		dispose();
		System.exit(1);
	}
//
	public void windowClosed(WindowEvent we) { }
	public void windowOpened(WindowEvent we) { }
	public void windowIconified(WindowEvent we) { }
	public void windowDeiconified(WindowEvent we) { }
	public void windowActivated(WindowEvent we) { }
	public void windowDeactivated(WindowEvent we) { }
//
	public void actionPerformed(ActionEvent ae) {
		if(connect.equals(ae.getSource())) {
			if("Connect" == connect.getLabel()) {
				sc.connect(hostname.getText(), 21002);				// aibõ|[gԍ 21002 ɐڑAo̓Xg[J
				sc.r_code(p_act + "SMESS.ERROR.ERROR2");			// LED_
				this.menu_enable(true);
				connect.setLabel("DisConnect");
			} else {
				sc.r_code(p_act + "SMESS.MODE.CLEAR");				// LEDNA
				sc.r_code("@DISS\n");								// ڑ
				sc.disconnect();									// o̓Xg[
				sc.socketclose();									// ڑ
				this.menu_enable(false);
				connect.setLabel("Connect");
			}
		} else if("DisConnect" == connect.getLabel()) {
			if(stand.equals(ae.getSource())) {
				sc.r_code(p_act + "STAND");							// 
			} else if(sit.equals(ae.getSource())) {
				sc.r_code(p_act + "SIT");							// 
			} else if(lie.equals(ae.getSource())) {
				sc.r_code(p_act + "LIE");							// 
			} else if(walk_sBy.equals(ae.getSource())) {
				sc.r_code(p_act + "CHGPOS.WALK.NORMAL");			// s
			} else if(start_lie.equals(ae.getSource())) {
				sc.r_code(p_act + "CHGPOS.STATR.NORMAL");			// (2)
			} else if(walk.equals(ae.getSource())) {
				walk_control(0);									// Oi
			} else if(stop.equals(ae.getSource())) {
				sc.r_code(p_act + "STOP_WALK");						// s~
			} else if(back.equals(ae.getSource())) {
				walk_control(180);									// i
			} else if(left.equals(ae.getSource())) {
				walk_control(60);									// Ɉړ
			} else if(right.equals(ae.getSource())) {
				walk_control(-60);									// EɈړ
			} else if(l_walk.equals(ae.getSource())) {
				walk_control(30);									// ΂ߑOɐi
			} else if(r_walk.equals(ae.getSource())) {
				walk_control(-30);									// E΂ߑOɐi
			} else if(l_back.equals(ae.getSource())) {
				walk_control(150);									// ΂ߌi
			} else if(r_back.equals(ae.getSource())) {
				walk_control(-150);									// E΂ߌi
			} else if(headingL.equals(ae.getSource())) {
				sc.r_code(p_act + "CONTACT.FRONT.HEADL");			// wfBO
			} else if(heading.equals(ae.getSource())) {
				sc.r_code(p_act + "CONTACT.FRONT.HEAD");			// ʃwfBO
			} else if(headingR.equals(ae.getSource())) {
				sc.r_code(p_act + "CONTACT.FRONT.HEADR");			// EwfBO
			} else if(headMov.equals(ae.getSource())) {
				sc.r_code(p_act + "MOVE.HEAD.FAST:"
					+ (-headHS.getValue()) + ":" + (-headVS.getValue()));	// ẘpxɂ
			} else if(kick.equals(ae.getSource())) {
				sc.r_code(p_act + "KICK:"
					+ (-h_angHS.getValue()) + ":" + h_dist.getText());	// LbN
			} else if(sit_touch.equals(ae.getSource())) {
				sc.r_code(p_act + "CONTACT.RIGHT.TOUCH:"
					+ (-h_angHS.getValue()) + ":" + h_dist.getText());	// ĉEŐG
			} else if(lie_touch.equals(ae.getSource())) {
				sc.r_code(p_act + "CONTACT.RIGHT.TOUCH2:"
					+ (-h_angHS.getValue()) + ":" + h_dist.getText());	// ĉEŐG
			} else if(l_Turn30.equals(ae.getSource())) {
				turn_control(30);									// 30x
			} else if(l_Turn90.equals(ae.getSource())) {
				turn_control(90);									// 90x
			} else if(l_Turn180.equals(ae.getSource())) {
				turn_control(180);									// 180x
			} else if(r_Turn30.equals(ae.getSource())) {
				turn_control(-30);									// E30x
			} else if(r_Turn90.equals(ae.getSource())) {
				turn_control(-90);									// E90x
			} else if(r_Turn180.equals(ae.getSource())) {
				turn_control(-180);									// E180x
			} else if(enter.equals(ae.getSource())) {
				sc.r_code(anyCmd.getText());						// CӃR}hs
			} else if(ts_all_resetB.equals(ae.getSource())) {
				this.ts_all_reset();
			} else if(status_resetB.equals(ae.getSource())) {
				sc.r_code("SET:Status:0");							// 
			} else if(ledItem1.equals(ae.getSource())) {
				sc.r_code(p_act + "SMESS.ERROR.ERROR1");			// fobOpG[ʒm1
			} else if(ledItem2.equals(ae.getSource())) {
				sc.r_code(p_act + "SMESS.ERROR.ERROR2");			// fobOpG[ʒm2
			} else if(ledItem3.equals(ae.getSource())) {
				sc.r_code(p_act + "SMESS.NOTICE.NOTICE1");			// fobOpʒm1
			} else if(ledItem4.equals(ae.getSource())) {
				sc.r_code(p_act + "SMESS.NOTICE.NOTICE2");			// fobOpʒm2
			} else if(ledItemEnd.equals(ae.getSource())) {
				sc.r_code(p_act + "SMESS.MODE.CLEAR");				// fobOp\NA

			} else if(headSM2Item1.equals(ae.getSource())) {
				sc.r_code(p_act + "SEARCH");						// T  ڕWTB
			} else if(headSM2Item2.equals(ae.getSource())) {
				sc.r_code(p_act + "SEARCH.HEAD.LOWCENT");			// ɌȂāAڕWT
			} else if(headSM2Item3.equals(ae.getSource())) {
				sc.r_code(p_act + "SEARCH.HEAD.NORMAL");			// ĂAڕWT
			} else if(headSM2Item4.equals(ae.getSource())) {
				sc.r_code(p_act + "SEARCH.HEAD.NORMALCENT");		// OɌȂāAڕWT
			} else if(headSM2Item5.equals(ae.getSource())) {
				sc.r_code(p_act + "TRACK_HEAD");					// ǐՂ
			} else if(headSM2ItemEnd.equals(ae.getSource())) {
				sc.r_code(p_act + "MOVE.HEAD.FAST:0:0");			// ftHg̐ʂɂ

			} else if(earItem1.equals(ae.getSource())) {
				sc.r_code(p_act + "PALONE.AUTO.EAR");				// 𓮂
			} else if(earItem2.equals(ae.getSource())) {
				sc.r_code(p_act + "PALONE.AUTO.EARL");				// 𓮂
			} else if(earItem3.equals(ae.getSource())) {
				sc.r_code(p_act + "PALONE.AUTO.EARR");				// E𓮂
			} else if(earItemEnd.equals(ae.getSource())) {
				sc.r_code(p_act + "PALONE.AUTO.EARSTOP");			// ̓~߂

			} else if(tailItem1.equals(ae.getSource())) {
				sc.r_code(p_act + "PALONE.AUTO.TAILUP");			// ۂグ
			} else if(tailItem2.equals(ae.getSource())) {
				sc.r_code(p_act + "PALONE.AUTO.TAILD");				// ۂ
			} else if(tailItem3.equals(ae.getSource())) {
				sc.r_code(p_act + "PALONE.AUTO.TAILH");				// ۂɐU
			} else if(tailItem4.equals(ae.getSource())) {
				sc.r_code(p_act + "PALONE.AUTO.TAILV");				// ۂcɐU
			} else if(tailItem5.equals(ae.getSource())) {
				sc.r_code(p_act + "PALONE.AUTO.TAILROT");			// ۂ
			} else if(tailItemEnd.equals(ae.getSource())) {
				sc.r_code(p_act + "PALONE.AUTO.TAILSTOP");			// ۂ̓~߂

			} else if(auto_pilot.equals(ae.getSource())) {
				if(auto_pilot_t == null) {
					sc.r_code(p_act + "SMESS.MODE.CLEAR");			// LEDNA
					sc.r_code("STOP");								// Stop
					auto_pilot_t = new ControlerAutoPilot(sc);
					auto_pilot_t.start();
				}

			} else if(r_code_load.equals(ae.getSource())) {
				this.set_request_stop_flag(true);
				FileDialog lfd = new FileDialog(this, "OPEN", FileDialog.LOAD); 
				lfd.setVisible(true); 
				if(lfd.getFile() != null) {
					sc.r_code("EDIT");								// Edit
					try { 
						BufferedReader in = new BufferedReader(new FileReader(lfd.getDirectory() + lfd.getFile()));
						String str;
						while ((str = in.readLine()) != null) {
//							log.append(str + "\n");
							sc.r_code(str);							//
							System.out.println(str);
						}
						in.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
					sc.r_code("END");								// End
				}
				this.set_request_stop_flag(false);
			} else if(r_code_run.equals(ae.getSource())) {
				sc.r_code("RUN");									// Run
			} else if(r_code_stop.equals(ae.getSource())) {
				sc.r_code("STOP");									// Stop
				this.end_auto_pilot_mode();
			} else if(r_code_quit.equals(ae.getSource())) {
				sc.r_code("QUIT");									// Quit
				this.end_auto_pilot_mode();
			}
		}

		if(actionlst.equals(ae.getSource())) {
			anyCmd.setText(actionlst.getSelectedItem());			// IR}h
		} else if(headDef.equals(ae.getSource())) {
			if("DisConnect" == connect.getLabel()) {
				sc.r_code(p_act + "MOVE.HEAD.FAST:0:0");			// ftHg̐ʂɂ
			}
			headTV.setText("0");
			headTH.setText("0");
			headVS.setValue(0);
			headHS.setValue(0);
		} else if(angle_jointItem.equals(ae.getSource())) {
			if(angle_frame == null) {
				this.angle_frame_start();
			} else {
				if(angle_frame.frame_closing == true) {
					this.angle_frame_start();
				} else {
					if(angle_frame.getState() == Frame.ICONIFIED) {
						angle_frame.setState(Frame.NORMAL);
					} else {
						angle_frame.setVisible(true);
					}
				}
			}
		} else if(other_system_valueItem.equals(ae.getSource())) {
			if(other_system_value_frame == null) {
				this.other_system_value_frame_start();
			} else {
				if(other_system_value_frame.frame_closing == true) {
					this.other_system_value_frame_start();
				} else {
					if(other_system_value_frame.getState() == Frame.ICONIFIED) {
						other_system_value_frame.setState(Frame.NORMAL);
					} else {
						other_system_value_frame.setVisible(true);
					}
				}
			}
		} else if(frontScanItem.equals(ae.getSource())) {
			if(frontScan_frame == null) {
				this.frontScan_frame_start();
			} else {
				if(frontScan_frame.frame_closing == true) {
					this.frontScan_frame_start();
				} else {
					if(frontScan_frame.getState() == Frame.ICONIFIED) {
						frontScan_frame.setState(Frame.NORMAL);
					} else {
						frontScan_frame.setVisible(true);
					}
				}
			}
		} else if(exitItem.equals(ae.getSource())) {
			if("DisConnect" == connect.getLabel()) {
				sc.r_code(p_act + "SMESS.MODE.CLEAR");				// LEDNA
				sc.r_code("QUIT");
				sc.r_code("@DISS");									// ڑ
			}
			System.exit(0);
		}
	}
// XN[o[̃Cxg 
	public void adjustmentValueChanged(AdjustmentEvent ae) { 
		if(ae.getSource() == headVS) {
			headTV.setText("" + (-ae.getAdjustable().getValue()) );
		} else if(ae.getSource() == headHS) {
			headTH.setText("" +  (-ae.getAdjustable().getValue()) );
		} else if(ae.getSource() == h_angHS) {
			h_ang.setText("" +  (-ae.getAdjustable().getValue()) );
		} else if(ae.getSource() == h_distVS) {
			h_dist.setText("" +  (-ae.getAdjustable().getValue()) );
		}
	}
//
	public void itemStateChanged(ItemEvent evt) {
		if("DisConnect" == connect.getLabel()) {
			if(cbH1.equals(evt.getSource())) {
				sc.r_code("SET:Head_ON:" + (cbH1.getState() ? 1 : 0));	// 
			} else if(cbH2.equals(evt.getSource())) {
				sc.r_code("SET:Head_Pat:" + (cbH2.getState() ? 1 : 0));	// 
			} else if(cbH3.equals(evt.getSource())) {
				sc.r_code("SET:Head_Hit:" + (cbH3.getState() ? 1 : 0));	// 
			} else if(cbH4.equals(evt.getSource())) {
				sc.r_code("SET:Head_LONG:" + (cbH4.getState() ? 1 : 0));	// 
			} else if(cbJ1.equals(evt.getSource())) {
				sc.r_code("SET:Jaw_ON:" + (cbJ1.getState() ? 1 : 0));	// 
			} else if(cbJ2.equals(evt.getSource())) {
				sc.r_code("SET:Jaw_LONG:" + (cbJ2.getState() ? 1 : 0));	// 
			} else if(cbB1.equals(evt.getSource())) {
				sc.r_code("SET:Back_ON:" + (cbB1.getState() ? 1 : 0));	// 
			} else if(cbB2.equals(evt.getSource())) {
				sc.r_code("SET:Back_LONG:" + (cbB2.getState() ? 1 : 0));	// 
			} else if(cbRF1.equals(evt.getSource())) {
				sc.r_code("SET:RFLeg_ON:" + (cbRF1.getState() ? 1 : 0));	// 
			} else if(cbRR1.equals(evt.getSource())) {
				sc.r_code("SET:RRLeg_ON:" + (cbRR1.getState() ? 1 : 0));	// 
			} else if(cbLF1.equals(evt.getSource())) {
				sc.r_code("SET:LFLeg_ON:" + (cbLF1.getState() ? 1 : 0));	// 
			} else if(cbLR1.equals(evt.getSource())) {
				sc.r_code("SET:LRLeg_ON:" + (cbLR1.getState() ? 1 : 0));	// 
			}
		}
		if(speed_normal.equals(evt.getSource())) {
			if(speed_mode) {
				speed_mode = false;
			}
		} else if(speed_slow.equals(evt.getSource())) {
			if(!speed_mode) {
				speed_mode = true;
			}
		}
	}
//
	public void set_request_stop_flag(boolean flag) {
		request_stop_flag = flag;
	}
//
	public void run() {
		int i;
		int count1 = 0;
		int count2 = 0;

		while(true) {
			try {
				Thread.sleep(100);
			} catch (InterruptedException e) {}
			if("DisConnect" == connect.getLabel()) {
				if(request_stop_flag == false) {
					if(count1 == 0) {
// ֐ߊpx₢킹
						for(i = 0; i < req_VLst1.length; i++) {
							sc.r_code("PRINT:\"#" + req_VLst1[i]);
							try {
								Thread.sleep(10);
							} catch (InterruptedException e) {}
						}
					}
					if(count2 == 0) {
// ̑̏₢킹
						for(i = 0; i < req_VLst2.length; i++) {
							sc.r_code("PRINT:\"#" + req_VLst2[i]);
							try {
								Thread.sleep(10);
							} catch (InterruptedException e) {}
						}
					}
				}
				count1++;
				if(count1 >= 2) {
					count1 = 0;
				}
				count2++;
				if(count2 >= 10) {
					count2 = 0;
				} else if(count2 == 5) {
					;
				}
// ^b`ZT[OFF܂łɌo߂ԕ\
				head_OFFT.setText("" + sc.mem_Head_OFF);
				rFLeg_OFFT.setText("" + sc.mem_RFLeg_OFF);
				lFLeg_OFFT.setText("" + sc.mem_LFLeg_OFF);
				rRLeg_OFFT.setText("" + sc.mem_RRLeg_OFF);
				lRLeg_OFFT.setText("" + sc.mem_LRLeg_OFF);
				jaw_OFFT.setText("" + sc.mem_Jaw_OFF);
				back_OFFT.setText("" + sc.mem_Back_OFF);
// ^b`ZT[\
				cbH1.setState(sc.mem_Head_ON != 0 ? true : false);
				cbH2.setState(sc.mem_Head_Pat != 0 ? true : false);
				cbH3.setState(sc.mem_Head_Hit != 0 ? true : false);
				cbH4.setState(sc.mem_Head_LONG != 0 ? true : false);

				cbJ1.setState(sc.mem_Jaw_ON != 0 ? true : false);
				cbJ2.setState(sc.mem_Jaw_LONG != 0 ? true : false);

				cbB1.setState(sc.mem_Back_ON != 0 ? true : false);
				cbB2.setState(sc.mem_Back_LONG != 0 ? true : false);

				cbRF1.setState(sc.mem_RFLeg_ON != 0 ? true : false);
				cbRR1.setState(sc.mem_RRLeg_ON != 0 ? true : false);
				cbLF1.setState(sc.mem_LFLeg_ON != 0 ? true : false);
				cbLR1.setState(sc.mem_LRLeg_ON != 0 ? true : false);
// {̏\
				batt_restT.setText("" + sc.mem_Batt_Rest);
				batt_tempT.setText("" + sc.mem_Batt_Temp);
				body_tempT.setText("" + sc.mem_Body_Temp);
				distanceT.setText("" + sc.mem_Distance);
				pink_ballT.setText("" + sc.mem_Pink_Ball);
				statusT.setText("" + sc.mem_Status);
				posture1T.setText("" + sc.mem_Posture1);

				this.posture1_comment();
			}
		}
	}
//
	public static void main(String args[]) {
		Cmd m = new Cmd();
		Thread t = new Thread(m);
		m.frame_start();
		t.start();
	}
}
