//	Angles.java
import java.awt.*;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
//import java.awt.event.MouseListener;
//import java.awt.event.MouseEvent;
import java.awt.Toolkit.*;

/*
 *
 */
class Angles extends Frame implements WindowListener, ActionListener, ItemListener, Runnable {
	MenuBar mb = new MenuBar();
	Menu exMenu, optionMenu;
	MenuItem saveItem, closeItem;
	MenuItem automatichkItem, manulaTeachingItem;

	boolean frame_closing = false;
	boolean report_stop = false;

	Checkbox cbHead;
	Checkbox cbRFLeg, cbRRLeg, cbLFLeg, cbLRLeg;
	Checkbox cbTail;

	TextField angle_Head_Tilt;				// Head_Tilt
	TextField angle_Head_Pan;				// Head_Pan
	TextField angle_Head_Roll;				// Head_Roll

	TextField angle_Mouth;					// Mouth

	TextField angle_RFLeg_1;				// RFLeg_1
	TextField angle_RFLeg_2;				// RFLeg_2
	TextField angle_RFLeg_3;				// RFLeg_3

	TextField angle_LFLeg_1;				// LFLeg_1
	TextField angle_LFLeg_2;				// LFLeg_2
	TextField angle_LFLeg_3;				// LFLeg_3

	TextField angle_RRLeg_1;				// RRLeg_1
	TextField angle_RRLeg_2;				// RRLeg_2
	TextField angle_RRLeg_3;				// RRLeg_3

	TextField angle_LRLeg_1;				// LRLeg_1
	TextField angle_LRLeg_2;				// LRLeg_2
	TextField angle_LRLeg_3;				// LRLeg_3

	TextField angle_Head_ON;				// Head_ON
	TextField angle_Head_OFF;				// Head_OFF
	TextField angle_Head_Pat;				// Head_Pat

	TextField angle_Tail_Pan;				// Tail_Pan
	TextField angle_Tail_Tilt;				// Tail_Tilt

	TextField framesTF;
	Button watchB, captureB, playbackB;
	Button stepFrameDownB, stepFrameUpB, recFrameB, all_unlockB, showLTB;

	SimpleCommander sc;
	Aibo3DView a3d;

	final short MAX_FRAMES = 200;

	short [] data_Head_Tilt = new short[MAX_FRAMES];				// Head_Tilt
	short [] data_Head_Pan = new short[MAX_FRAMES];					// Head_Pan
	short [] data_Head_Roll = new short[MAX_FRAMES];				// Head_Roll

	short [] data_Mouth = new short[MAX_FRAMES];					// Mouth

	short [] data_RFLeg_1 = new short[MAX_FRAMES];					// RFLeg_1
	short [] data_RFLeg_2 = new short[MAX_FRAMES];					// RFLeg_2
	short [] data_RFLeg_3 = new short[MAX_FRAMES];					// RFLeg_3

	short [] data_LFLeg_1 = new short[MAX_FRAMES];					// LFLeg_1
	short [] data_LFLeg_2 = new short[MAX_FRAMES];					// LFLeg_2
	short [] data_LFLeg_3 = new short[MAX_FRAMES];					// LFLeg_3

	short [] data_RRLeg_1 = new short[MAX_FRAMES];					// RRLeg_1
	short [] data_RRLeg_2 = new short[MAX_FRAMES];					// RRLeg_2
	short [] data_RRLeg_3 = new short[MAX_FRAMES];					// RRLeg_3

	short [] data_LRLeg_1 = new short[MAX_FRAMES];					// LRLeg_1
	short [] data_LRLeg_2 = new short[MAX_FRAMES];					// LRLeg_2
	short [] data_LRLeg_3 = new short[MAX_FRAMES];					// LRLeg_3

	short [] data_Head_ON = new short[MAX_FRAMES];					// Head_ON
	short [] data_Head_OFF = new short[MAX_FRAMES];					// Head_OFF
	short [] data_Head_Pat = new short[MAX_FRAMES];					// Head_Pat

	short [] data_Tail_Pan = new short[MAX_FRAMES];					// Tail_Pan
	short [] data_Tail_Tilt = new short[MAX_FRAMES];				// Tail_Tilt

	short frame = 0;
	short teachFrame = 0;
	boolean over_frames = false;
	boolean playback_start = false;
	boolean playback_first = false;
	boolean manulaTeaching = false;
	boolean last_time_show_request = false;

	public Angles(SimpleCommander id) {
		super("Angles of joint");
		addWindowListener(this);
		sc = id;

		exMenu = new Menu("File");
		exMenu.add(saveItem = new MenuItem("MTN Save"));			// ۑ
		exMenu.addSeparator();
		exMenu.add(closeItem = new MenuItem("Close"));				// 
		saveItem.setEnabled(false);

		optionMenu = new Menu("Option");
		optionMenu.add(automatichkItem = new MenuItem("Automatichk"));
		optionMenu.add(manulaTeachingItem = new MenuItem("Manual Teaching"));
		automatichkItem.setEnabled(false);

		mb.add(exMenu);
		mb.add(optionMenu);

		setMenuBar(mb);

		saveItem.addActionListener(this);
		closeItem.addActionListener(this);
		automatichkItem.addActionListener(this);
		manulaTeachingItem.addActionListener(this);

		setLayout(new BorderLayout());

		Panel centerP = new Panel();
		centerP.setLayout(new GridLayout(11,1));
		centerP.add(new Label("Head"));
		centerP.add(cbHead = new Checkbox("Lock", false));
		centerP.add(angle_Head_Tilt = new TextField("0",4));		// Head_Tilt
		centerP.add(angle_Head_Pan = new TextField("0",4));			// Head_Pan
		centerP.add(angle_Head_Roll = new TextField("0",4));		// Head_Roll
		centerP.add(new Label("Mouth"));
		centerP.add(angle_Mouth = new TextField("0",4));			// Mouth
		centerP.add(new Label("Tail"));
		centerP.add(cbTail = new Checkbox("Lock", false));
		centerP.add(angle_Tail_Pan = new TextField("0",4));			// Tail_Pan
		centerP.add(angle_Tail_Tilt = new TextField("0",4));		// Tail_Tilt
		cbHead.setEnabled(false);
		angle_Head_Tilt.setEditable(false);
		angle_Head_Pan.setEditable(false);
		angle_Head_Roll.setEditable(false);
		angle_Mouth.setEditable(false);
		cbTail.setEnabled(false);
		angle_Tail_Pan.setEditable(false);
		angle_Tail_Tilt.setEditable(false);

		Panel rflegP = new Panel();
		rflegP.setLayout(new GridLayout(5,1));
		rflegP.add(new Label("RFLeg"));
		rflegP.add(cbRFLeg = new Checkbox("Lock", false));
		rflegP.add(angle_RFLeg_1 = new TextField("0",4));			// RFLeg_1
		rflegP.add(angle_RFLeg_2 = new TextField("0",4));			// RFLeg_2
		rflegP.add(angle_RFLeg_3 = new TextField("0",4));			// RFLeg_3
		cbRFLeg.setEnabled(false);
		angle_RFLeg_1.setEditable(false);
		angle_RFLeg_2.setEditable(false);
		angle_RFLeg_3.setEditable(false);

		Panel lflegP = new Panel();
		lflegP.setLayout(new GridLayout(5,1));
		lflegP.add(new Label("LFLeg"));
		lflegP.add(cbLFLeg = new Checkbox("Lock", false));
		lflegP.add(angle_LFLeg_1 = new TextField("0",4));			// LFLeg_1
		lflegP.add(angle_LFLeg_2 = new TextField("0",4));			// LFLeg_2
		lflegP.add(angle_LFLeg_3 = new TextField("0",4));			// LFLeg_3
		cbLFLeg.setEnabled(false);
		angle_LFLeg_1.setEditable(false);
		angle_LFLeg_2.setEditable(false);
		angle_LFLeg_3.setEditable(false);

		Panel rrlegP = new Panel();
		rrlegP.setLayout(new GridLayout(5,1));
		rrlegP.add(new Label("RRLeg"));
		rrlegP.add(cbRRLeg = new Checkbox("Lock", false));
		rrlegP.add(angle_RRLeg_1 = new TextField("0",4));			// RRLeg_1
		rrlegP.add(angle_RRLeg_2 = new TextField("0",4));			// RRLeg_2
		rrlegP.add(angle_RRLeg_3 = new TextField("0",4));			// RRLeg_3
		cbRRLeg.setEnabled(false);
		angle_RRLeg_1.setEditable(false);
		angle_RRLeg_2.setEditable(false);
		angle_RRLeg_3.setEditable(false);

		Panel lrlegP = new Panel();
		lrlegP.setLayout(new GridLayout(5,1));
		lrlegP.add(new Label("LRLeg"));
		lrlegP.add(cbLRLeg = new Checkbox("Lock", false));
		lrlegP.add(angle_LRLeg_1 = new TextField("0",4));			// LRLeg_1
		lrlegP.add(angle_LRLeg_2 = new TextField("0",4));			// LRLeg_2
		lrlegP.add(angle_LRLeg_3 = new TextField("0",4));			// LRLeg_3
		cbLRLeg.setEnabled(false);
		angle_LRLeg_1.setEditable(false);
		angle_LRLeg_2.setEditable(false);
		angle_LRLeg_3.setEditable(false);

		Panel rlegP = new Panel();
		rlegP.setLayout(new GridLayout(2,1));
		rlegP.add(rflegP);
		rlegP.add(rrlegP);

		Panel llegP = new Panel();
		llegP.setLayout(new GridLayout(2,1));
		llegP.add(lflegP);
		llegP.add(lrlegP);

		Panel angleP = new Panel();
		angleP.setLayout(new GridLayout(1,3));
		angleP.add(llegP);
		angleP.add(centerP);
		angleP.add(rlegP);

		a3d = new Aibo3DView();
		a3d.setSize(240,240);
		a3d.setForeground(Color.yellow); 
		a3d.setBackground(Color.black);

		Panel control_SubP = new Panel();
		control_SubP.setLayout(new GridLayout(1,2));
		control_SubP.add(stepFrameDownB = new Button("<<"));
		control_SubP.add(stepFrameUpB = new Button(">>"));

		Panel controlP = new Panel();
		controlP.setLayout(new GridLayout(2,4));
		controlP.add(framesTF = new TextField("0",4));
		controlP.add(watchB = new Button("Watch"));
		controlP.add(captureB = new Button("Capture"));
		controlP.add(playbackB = new Button("Playback"));
		controlP.add(control_SubP);
		controlP.add(recFrameB = new Button("REC Frame"));
		controlP.add(all_unlockB = new Button("All unlock"));
		controlP.add(showLTB = new Button("LT Show"));
		framesTF.setEditable(false);
		stepFrameDownB.setEnabled(false);
		stepFrameUpB.setEnabled(false);
		recFrameB.setEnabled(false);
		all_unlockB.setEnabled(false);
		showLTB.setEnabled(false);
//		add(new Label("N"), "North");
//		add(new Label("W"),"West");
		add(angleP,"East");
		add(a3d, "Center");
		add(controlP, "South"); 

		watchB.addActionListener(this);
		captureB.addActionListener(this);
		playbackB.addActionListener(this);
		stepFrameDownB.addActionListener(this);
		stepFrameUpB.addActionListener(this);
		recFrameB.addActionListener(this);
		all_unlockB.addActionListener(this);
		showLTB.addActionListener(this);

		cbHead.addItemListener(this);
		cbRFLeg.addItemListener(this);
		cbRRLeg.addItemListener(this);
		cbLFLeg.addItemListener(this);
		cbLRLeg.addItemListener(this);
		cbTail.addItemListener(this);
	}

	public void frame_start() {
		setSize(400,300);
		setResizable(false);
		setVisible(true);
	}

	public void windowClosing(WindowEvent we) {
		this.frame_closing = true;
		dispose();
	}

	public void windowClosed(WindowEvent we) { }
	public void windowOpened(WindowEvent we) { }
	public void windowIconified(WindowEvent we) { }
	public void windowDeiconified(WindowEvent we) { }
	public void windowActivated(WindowEvent we) { }
	public void windowDeactivated(WindowEvent we) { }

	public void setCB_State(boolean mode) {
		cbHead.setState(mode);
		cbTail.setState(mode);
		cbRFLeg.setState(mode);
		cbLFLeg.setState(mode);
		cbRRLeg.setState(mode);
		cbLRLeg.setState(mode);
	};

	public void setCB_Enabled(boolean mode) {
		cbHead.setEnabled(mode);
		cbTail.setEnabled(mode);
		cbRFLeg.setEnabled(mode);
		cbLFLeg.setEnabled(mode);
		cbRRLeg.setEnabled(mode);
		cbLRLeg.setEnabled(mode);
	};

	public void copy_angles(int dis, int [] target) {
		target[0] = data_Head_Tilt[dis];
		target[1] = data_Head_Pan[dis];
		target[2] = data_Head_Roll[dis];
		target[3] = data_Mouth[dis];
		target[4] = 0;
		target[5] = 0;

		target[6] = data_LFLeg_1[dis];
		target[7] = data_LFLeg_2[dis];
		target[8] = data_LFLeg_3[dis];

		target[9] = data_LRLeg_1[dis];
		target[10] = data_LRLeg_2[dis];
		target[11] = data_LRLeg_3[dis];

		target[12] = data_RFLeg_1[dis];
		target[13] = data_RFLeg_2[dis];
		target[14] = data_RFLeg_3[dis];

		target[15] = data_RRLeg_1[dis];
		target[16] = data_RRLeg_2[dis];
		target[17] = data_RRLeg_3[dis];

		target[18] = data_Tail_Pan[dis];
		target[19] = data_Tail_Tilt[dis];
	}

	public void save_motoin_frame() {
		int i;
		int [] body = {
			0, 0, 0
		};
		int [] angles = new int[20];
		boolean status = false;

		Save_mtn_file smf = new Save_mtn_file();
		if(smf.open_MtnFile() == 0) {
			if(smf.output_first_mtn_file() == 0) {
				for(i = 0; i < frame; i++) {
					copy_angles(i, angles);
					if(smf.output4_2_mtn_file(30, body, angles) != 0) {
						status = true;
						break;
					}
				}
				if(!status) {
					if(smf.output_last_mtn_file() == 0) {
						if(smf.close_MtnFile() == 0) {
							smf.rewirte_key_frames();
						}
					}
					Toolkit.getDefaultToolkit().beep();
				}
			}
		}
	}

	public void actionPerformed(ActionEvent ae) {
		if(watchB.equals(ae.getSource())) {
			report_stop = false;
			playback_start = false;
		} else if(captureB.equals(ae.getSource())) {
			report_stop = true;
			playback_start = false;
		} else if(playbackB.equals(ae.getSource())) {
			report_stop = false;
			playback_start = true;
			playback_first = true;
		} else if(stepFrameDownB.equals(ae.getSource())) {
//			if(teachFrame > 0) {
//				teachFrame--;
//				if(teachFrame == 0) {
//					stepFrameDownB.setEnabled(false);
//				}
//				setCB_State(true);
//				stepFrameUpB.setEnabled(true);
//			} else {
//				stepFrameDownB.setEnabled(false);
//			}
			;
		} else if(stepFrameUpB.equals(ae.getSource())) {
//			if(teachFrame < frame) {
//				teachFrame++;
//				setCB_State(true);
//				if(teachFrame == frame) {
//					stepFrameUpB.setEnabled(false);
//				}
//			} else {
//				stepFrameUpB.setEnabled(false);
//			}
//			stepFrameDownB.setEnabled(true);
			;
		} else if(recFrameB.equals(ae.getSource())) {
			if(teachFrame < MAX_FRAMES - 1) {
				set_angle_LTdata(frame);
				frame++;
				set_temp_angle_data(frame);

				show_angle_data(frame);
				set_angle_data(frame);
				a3d.repaint();

				teachFrame = frame;
				setCB_State(true);
//				stepFrameDownB.setEnabled(true);
			}
		} else if(all_unlockB.equals(ae.getSource())) {
			setCB_State(false);
		} else if(showLTB.equals(ae.getSource())) {
			a3d.setLTPaint(last_time_show_request = !last_time_show_request);
			a3d.repaint();
		} else if(saveItem.equals(ae.getSource())) {
			save_motoin_frame();
		} else if(closeItem.equals(ae.getSource())) {
			this.frame_closing = true;
			dispose();
		} else if(automatichkItem.equals(ae.getSource())) {
			saveItem.setEnabled(false);
			automatichkItem.setEnabled(false);
			manulaTeachingItem.setEnabled(true);
			manulaTeaching = false;

			stepFrameDownB.setEnabled(false);
			stepFrameUpB.setEnabled(false);
			recFrameB.setEnabled(false);
			setCB_State(false);
			setCB_Enabled(false);
			all_unlockB.setEnabled(false);
			showLTB.setEnabled(false);
			last_time_show_request = false;

			a3d.setLTPaint(false);
			a3d.repaint();

			watchB.setEnabled(true);
			captureB.setEnabled(true);
			playbackB.setEnabled(true);
		} else if(manulaTeachingItem.equals(ae.getSource())) {
			saveItem.setEnabled(true);
			manulaTeachingItem.setEnabled(false);
			automatichkItem.setEnabled(true);
			manulaTeaching = true;

			frame = 0;
			over_frames = false;
			get_angle_data(frame);
			set_angle_LTdata(frame);

			watchB.setEnabled(false);
			captureB.setEnabled(false);
			playbackB.setEnabled(false);

			setCB_State(true);
			setCB_Enabled(true);
			recFrameB.setEnabled(true);
			all_unlockB.setEnabled(true);
			showLTB.setEnabled(true);
		}
	}

	public void get_angle_data(short dis) {
		if(!cbHead.getState()) {
			data_Head_Tilt[dis] = (short)sc.mem_Head_Tilt;
			data_Head_Pan[dis] = (short)sc.mem_Head_Pan;
			data_Head_Roll[dis] = (short)sc.mem_Head_Roll;
			data_Mouth[dis] = (short)sc.mem_Mouth;
		}
		if(!cbTail.getState()) {
			data_Tail_Pan[dis] = (short)sc.mem_Tail_Pan;
			data_Tail_Tilt[dis] = (short)sc.mem_Tail_Tilt;
		}
		if(!cbRFLeg.getState()) {
			data_RFLeg_1[dis] = (short)sc.mem_RFLeg_1;
			data_RFLeg_2[dis] = (short)sc.mem_RFLeg_2;
			data_RFLeg_3[dis] = (short)sc.mem_RFLeg_3;
		}
		if(!cbLFLeg.getState()) {
			data_LFLeg_1[dis] = (short)sc.mem_LFLeg_1;
			data_LFLeg_2[dis] = (short)sc.mem_LFLeg_2;
			data_LFLeg_3[dis] = (short)sc.mem_LFLeg_3;
		}
		if(!cbRRLeg.getState()) {
			data_RRLeg_1[dis] = (short)sc.mem_RRLeg_1;
			data_RRLeg_2[dis] = (short)sc.mem_RRLeg_2;
			data_RRLeg_3[dis] = (short)sc.mem_RRLeg_3;
		}
		if(!cbLRLeg.getState()) {
			data_LRLeg_1[dis] = (short)sc.mem_LRLeg_1;
			data_LRLeg_2[dis] = (short)sc.mem_LRLeg_2;
			data_LRLeg_3[dis] = (short)sc.mem_LRLeg_3;
		}
	}

	public void set_temp_angle_data(short dis) {
		int back = dis == 0 ? MAX_FRAMES - 1 : dis - 1;

		data_Head_Tilt[dis] = data_Head_Tilt[back];
		data_Head_Pan[dis] = data_Head_Pan[back];
		data_Head_Roll[dis] = data_Head_Roll[back];
		data_Mouth[dis] = data_Mouth[back];

		data_Tail_Pan[dis] = data_Tail_Pan[back];
		data_Tail_Tilt[dis] = data_Tail_Tilt[back];

		data_RFLeg_1[dis] = data_RFLeg_1[back];
		data_RFLeg_2[dis] = data_RFLeg_2[back];
		data_RFLeg_3[dis] = data_RFLeg_3[back];

		data_LFLeg_1[dis] = data_LFLeg_1[back];
		data_LFLeg_2[dis] = data_LFLeg_2[back];
		data_LFLeg_3[dis] = data_LFLeg_3[back];

		data_RRLeg_1[dis] = data_RRLeg_1[back];
		data_RRLeg_2[dis] = data_RRLeg_2[back];
		data_RRLeg_3[dis] = data_RRLeg_3[back];

		data_LRLeg_1[dis] = data_LRLeg_1[back];
		data_LRLeg_2[dis] = data_LRLeg_2[back];
		data_LRLeg_3[dis] = data_LRLeg_3[back];
	}

	public void set_angle_data(short dis) {
		a3d.angleHead_Tilt = data_Head_Tilt[dis];
		a3d.angleHead_Pan = data_Head_Pan[dis];
		a3d.angleHead_Roll = data_Head_Roll[dis];

		a3d.angleMouth = data_Mouth[dis];

//		a3d.angleHead_Tilt = Integer.parseInt(angle_Head_Tilt.getText());
//		a3d.angleHead_Pan = Integer.parseInt(angle_Head_Pan.getText());
//		a3d.angleHead_Roll = Integer.parseInt(angle_Head_Roll.getText());

//		a3d.angleMouth = Integer.parseInt(angle_Mouth.getText());

		a3d.angleTail_Pan = data_Tail_Pan[dis];
		a3d.angleTail_Tilt = data_Tail_Tilt[dis];

		a3d.angleRFLeg_1 = data_RFLeg_1[dis];
		a3d.angleRFLeg_2 = data_RFLeg_2[dis];
		a3d.angleRFLeg_3 = data_RFLeg_3[dis];

		a3d.angleLFLeg_1 = data_LFLeg_1[dis];
		a3d.angleLFLeg_2 = data_LFLeg_2[dis];
		a3d.angleLFLeg_3 = data_LFLeg_3[dis];

		a3d.angleRRLeg_1 = data_RRLeg_1[dis];
		a3d.angleRRLeg_2 = data_RRLeg_2[dis];
		a3d.angleRRLeg_3 = data_RRLeg_3[dis];

		a3d.angleLRLeg_1 = data_LRLeg_1[dis];
		a3d.angleLRLeg_2 = data_LRLeg_2[dis];
		a3d.angleLRLeg_3 = data_LRLeg_3[dis];
	}

	public void set_angle_LTdata(short dis) {
		a3d.angleHead_Tilt_LT = data_Head_Tilt[dis];
		a3d.angleHead_Pan_LT = data_Head_Pan[dis];
		a3d.angleHead_Roll_LT = data_Head_Roll[dis];

		a3d.angleMouth_LT = data_Mouth[dis];

		a3d.angleTail_Pan_LT = data_Tail_Pan[dis];
		a3d.angleTail_Tilt_LT = data_Tail_Tilt[dis];

		a3d.angleRFLeg_1_LT = data_RFLeg_1[dis];
		a3d.angleRFLeg_2_LT = data_RFLeg_2[dis];
		a3d.angleRFLeg_3_LT = data_RFLeg_3[dis];

		a3d.angleLFLeg_1_LT = data_LFLeg_1[dis];
		a3d.angleLFLeg_2_LT = data_LFLeg_2[dis];
		a3d.angleLFLeg_3_LT = data_LFLeg_3[dis];

		a3d.angleRRLeg_1_LT = data_RRLeg_1[dis];
		a3d.angleRRLeg_2_LT = data_RRLeg_2[dis];
		a3d.angleRRLeg_3_LT = data_RRLeg_3[dis];

		a3d.angleLRLeg_1_LT = data_LRLeg_1[dis];
		a3d.angleLRLeg_2_LT = data_LRLeg_2[dis];
		a3d.angleLRLeg_3_LT = data_LRLeg_3[dis];
	}

	public void show_angle_data(short dis) {
		angle_Head_Tilt.setText("" + data_Head_Tilt[dis]);			// Head_Tilt
		angle_Head_Pan.setText("" + data_Head_Pan[dis]);			// Head_Pan
		angle_Head_Roll.setText("" + data_Head_Roll[dis]);			// Head_Roll

		angle_Mouth.setText("" + data_Mouth[dis]);					// Mouth

		angle_Tail_Pan.setText("" + data_Tail_Pan[dis]);			// Tail_Pan
		angle_Tail_Tilt.setText("" + data_Tail_Tilt[dis]);			// Tail_Tilt

		angle_RFLeg_1.setText("" + data_RFLeg_1[dis]);				// RFLeg_1
		angle_RFLeg_2.setText("" + data_RFLeg_2[dis]);				// RFLeg_2
		angle_RFLeg_3.setText("" + data_RFLeg_3[dis]);				// RFLeg_3

		angle_LFLeg_1.setText("" + data_LFLeg_1[dis]);				// LFLeg_1
		angle_LFLeg_2.setText("" + data_LFLeg_2[dis]);				// LFLeg_2
		angle_LFLeg_3.setText("" + data_LFLeg_3[dis]);				// LFLeg_3

		angle_RRLeg_1.setText("" + data_RRLeg_1[dis]);				// RRLeg_1
		angle_RRLeg_2.setText("" + data_RRLeg_2[dis]);				// RRLeg_2
		angle_RRLeg_3.setText("" + data_RRLeg_3[dis]);				// RRLeg_3

		angle_LRLeg_1.setText("" + data_LRLeg_1[dis]);				// LRLeg_1
		angle_LRLeg_2.setText("" + data_LRLeg_2[dis]);				// LRLeg_2
		angle_LRLeg_3.setText("" + data_LRLeg_3[dis]);				// LRLeg_3
	}

	public boolean check_not_same_data(short dis) {
		int comp;

		if(over_frames) {
			comp = dis == 0 ? MAX_FRAMES - 1 : dis - 1;
		} else {
			comp = dis == 0 ? MAX_FRAMES - 1 : dis - 1;
		}
		if(data_Head_Tilt[dis] != data_Head_Tilt[comp] |
			data_Head_Pan[dis] != data_Head_Pan[comp] |
			data_Head_Roll[dis] != data_Head_Roll[comp] |

			data_Mouth[dis] != data_Mouth[comp] |

			data_Tail_Pan[dis] != data_Tail_Pan[comp] |
			data_Tail_Tilt[dis] != data_Tail_Tilt[comp] |

			data_RFLeg_1[dis] != data_RFLeg_1[comp] |
			data_RFLeg_2[dis] != data_RFLeg_2[comp] |
			data_RFLeg_3[dis] != data_RFLeg_3[comp] |

			data_LFLeg_1[dis] != data_LFLeg_1[comp] |
			data_LFLeg_2[dis] != data_LFLeg_2[comp] |
			data_LFLeg_3[dis] != data_LFLeg_3[comp] |

			data_RRLeg_1[dis] != data_RRLeg_1[comp] |
			data_RRLeg_2[dis] != data_RRLeg_2[comp] |
			data_RRLeg_3[dis] != data_RRLeg_3[comp] |

			data_LRLeg_1[dis] != data_LRLeg_1[comp] |
			data_LRLeg_2[dis] != data_LRLeg_2[comp] |
			data_LRLeg_3[dis] != data_LRLeg_3[comp]) {
			return(true);
		} else {
			return(false);
		}
	}

	public void itemStateChanged(ItemEvent evt) {
		if(cbHead.equals(evt.getSource())) {;
			;
		} else if(cbTail.equals(evt.getSource())) {
			;
		} else if(cbRFLeg.equals(evt.getSource())) {
			;
		} else if(cbRFLeg.equals(evt.getSource())) {
			;
		} else if(cbRFLeg.equals(evt.getSource())) {
			;
		} else if(cbLRLeg.equals(evt.getSource())) {
			;
		}
	}

	public void run() {
		short dis = 0;

		get_angle_data(dis);
		set_angle_LTdata(dis);
		show_angle_data(dis);
		set_angle_data(dis);
		a3d.repaint();

		while(true) {
			if(this.frame_closing) {
				break;
			}

			try {
				Thread.sleep(100);
			} catch (InterruptedException e) {}

			if(report_stop) {
				continue;
			}

			if(playback_start) {
				if(playback_first) {
					if(over_frames) {
						if(frame == MAX_FRAMES - 1) {
							dis = 0;
						} else {
							dis = frame;
						}
					} else {
						dis = 0;
					}
					playback_first = false;
				}
			} else {
				get_angle_data(frame);
				dis = frame;
				if(manulaTeaching) {
//					dis = teachFrame;
					;
				} else {
					frame++;
				}
				if(frame >= MAX_FRAMES) {
					frame = 0;
					over_frames = true;
				}
			}
//			System.out.println("dis = " + dis); 
			show_angle_data(dis);
			set_angle_data(dis);
			if(check_not_same_data(dis)) {
				a3d.repaint();
			}
			framesTF.setText("" + dis);
			if(playback_start) {
				if(over_frames) {
					if(dis != (frame == 0 ? MAX_FRAMES - 1 : frame - 1)) {
						dis++;
						if(dis >= MAX_FRAMES) {
							dis = 0;
						}
					} else {
						dis = (short)(frame == 0 ? MAX_FRAMES - 1 : frame - 1);
					}
				} else {
					dis++;
					if(dis >= frame - 1) {
						dis = (short)((int)frame - 1);
					}
				}
			}
		}
	}
}
