//	ShowDistance.java
import java.awt.*;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
//import java.awt.event.ActionListener;
//import java.awt.event.ActionEvent;
import java.util.*;

/*
 *
 */
class ShowDistance extends Frame implements WindowListener, Runnable {
	boolean frame_closing = false;

	SimpleCommander sc;
	DistancePoint dp;
	DistanceField df;

	Button field_scanB;
	final int [] sleep_table = {
		0, 50, 100, 150, 200, 250, 300, 350, 400, 450
	};
	int table_num;

	public ShowDistance(SimpleCommander id) {
		super("Show Distance");
		addWindowListener(this);
		this.setBackground(Color.white);

		dp = new DistancePoint();
		df = new DistanceField();
		sc = id;

		field_scanB = new Button("Field scan");
		field_scanB.setEnabled(false);

		setLayout(new BorderLayout());

//		Panel centerP = new Panel();

//		add(new TextField("0",4), "North");
		add(dp,"West");
		add(field_scanB,"East");
		add(df, "Center");
//		add(new Label("S"), "South"); 
	}

	public void frame_start() {
		setSize(305,130);
		setResizable(false);
		setVisible(true);
	}

	public void windowClosing(WindowEvent we) {
		this.frame_closing = true;
		dispose();
//		System.exit(1);
	}

	public void windowClosed(WindowEvent we) { }
	public void windowOpened(WindowEvent we) { }
	public void windowIconified(WindowEvent we) { }
	public void windowDeiconified(WindowEvent we) { }
	public void windowActivated(WindowEvent we) { }
	public void windowDeactivated(WindowEvent we) { }

	public void run() {
//		Random rnd = new Random();
		while(true) {
			if(this.frame_closing) {
				break;
			}
			try {
//				table_num = rnd.nextInt(10);	/* 0 - 9 ̃e[u */
				if(sc.mem_Distance < 150) {
					table_num = 0;	/* 0 - 9 ̃e[u */
				} else {
					table_num = sc.mem_Distance / 100;	/* 0 - 9 ̃e[u */
				}
				dp.set_PointTable(table_num);
//				sc.mem_Batt_Rest;
//				sc.mem_Batt_Temp;
//				sc.mem_Body_Temp;
//				sc.mem_Head_Tilt;
//				sc.mem_Head_Pan;
				dp.set_PointSwitch(false);
				dp.repaint();/*  */
				Thread.sleep(sleep_table[table_num] + 100);	/* ɉđ҂ԂύX */
				dp.set_PointSwitch(true);
				dp.repaint();/*  */
				Thread.sleep(sleep_table[table_num] + 100);	/* ɉđ҂ԂύX */
			} catch (InterruptedException e) {}
		}
	}
//
//	public static void main(String args[]) {
//		ShowDistance m = new ShowDistance();
//		Thread t = new Thread(m);
//		m.frame_start();
//		t.start();
//	}
}

/*
 *
 */
class DistancePoint extends Canvas {
	boolean point_on_flg;
	int table_num = 0;
	final int [] radius_table = {
		60, 50, 40, 36, 32, 28, 24, 20, 16, 12
	};
	final Color [] color_table = {
		Color.red, Color.red, Color.magenta, Color.orange, Color.yellow,
		Color.green, Color.cyan, Color.blue, Color.white,  Color.gray
	};

	public DistancePoint() {
		this.setSize(100,100);
		this.setForeground(Color.yellow); 
		this.setBackground(Color.darkGray);
	}

	public void set_PointSwitch(boolean mode) {
		point_on_flg = mode;
	}

	public void set_PointTable(int num) {
		if(num >= 0 && num < radius_table.length) {
			table_num = num;
		} else {
			table_num = 0;
		}
	}

	public void paint(Graphics g) {
		g.setColor(Color.white);
		g.drawString("Distance Sencer", 0, 10);
//		g.drawString("Tilt=", 0, getSize().height - 5);
		if(point_on_flg) {
			g.setColor(color_table[table_num]);
			g.fillOval((getSize().width - radius_table[table_num]) / 2, (getSize().height - radius_table[table_num]) / 2, radius_table[table_num], radius_table[table_num]);
		}
	}
}

/*
 *
 */
class DistanceField extends Canvas {
	int i;

	public DistanceField() {
		this.setSize(130,100);
		this.setForeground(Color.yellow); 
		this.setBackground(Color.black);
	}

	public void paint(Graphics g) {
		for(i = 5; i < 100; i += 10) {
			if(i == 25) {
				g.setColor(Color.white);
			} else {
				g.setColor(Color.gray);
			}
			g.drawLine(0, i, 130, i);
		}
		for(i = 5; i < 130; i += 10) {
			if(i == 65) {
				g.setColor(Color.white);
			} else {
				g.setColor(Color.gray);
			}
			g.drawLine(i, 0, i, 100);
		}
	}
}
