//	Save_mtn_file.java
import java.io.*;

/*
 *
 */
class Save_mtn_file {
	FileOutputStream file_out;
	DataOutputStream data_out;
	RandomAccessFile myRAFile; 
	int status = 0;

	final String START_TAG = "OMTN";

	int sub_tag = 0;
	final int SUB_TAG_MAX = 4;

	short key_frames = 0;
	long seek_next;

	int start_style = 2;

	final String saveFileName = "sample_motion";
	final String saveFileExtension = "mtn";
	final String name = "a_stand#stand_" + saveFileName;
	final String creater = "hkora11 Cmd contorler";
	final String designLabel = "DRX-910";

	final String [] JOINT_PRM = {
		"PRM:/r1/c1-Joint2:j1",				/*  ㉺U */
		"PRM:/r1/c1/c2-Joint2:j2",			/*  EU */
		"PRM:/r1/c1/c2/c3-Joint2:j3",		/*  EX */
		"PRM:/r1/c1/c2/c3/c4-Joint2:j4",	/*  J */
		"PRM:/r1/c1/c2/c3/e1-Joint3:j5",	/*   */
		"PRM:/r1/c1/c2/c3/e2-Joint3:j6",	/*  E */
		"PRM:/r2/c1-Joint2:j1",				/* Or  */
		"PRM:/r2/c1/c2-Joint2:j2",			/* Or  */
		"PRM:/r2/c1/c2/c3-Joint2:j3",		/* Or O */
		"PRM:/r3/c1-Joint2:j1",				/* r  */
		"PRM:/r3/c1/c2-Joint2:j2",			/* r  */
		"PRM:/r3/c1/c2/c3-Joint2:j3",		/* r O */
		"PRM:/r4/c1-Joint2:j1",				/* EOr  */
		"PRM:/r4/c1/c2-Joint2:j2",			/* EOr  */
		"PRM:/r4/c1/c2/c3-Joint2:j3",		/* EOr O */
		"PRM:/r5/c1-Joint2:j1",				/* Er  */
		"PRM:/r5/c1/c2-Joint2:j2",			/* Er  */
		"PRM:/r5/c1/c2/c3-Joint2:j3",		/* Er O */
		"PRM:/r6/c1-Joint2:j1",				/*  E */
		"PRM:/r6/c2-Joint2:j2"				/*  ㉺ */
	};

	final int startKeyFrameLength = 0;
	final int endKeyFrameLength = 30;

	final int [] defaultKeyFrameSleepBody = {
		0, 0, 0
	};
	final int [] defaultKeyFrameSitBody = {
		0, 25, 0
	};
	final int [] defaultKeyFrameStandBody = {
		0, 2, 0
	};

	final int [] defaultKeyFrameSleepAngles = {
		-11, 0, 1, -3, 0, 0, 60, 0, 30, -117, 0, 147, 59, 0, 29, -117, 0, 147, 0, 0
	};
	final int [] defaultKeyFrameSitAngles = {
		-25, 0, 0, -3, 0, 0, 0, 0, 9, -90, 0, 134, -1, 0, 10, -91, 0, 135, 0, 0
	};
	final int [] defaultKeyFrameStandAngles = {
		0, 0, 0, -3, 0, 0, -10, 0, 30, -1, 0, 24, -11, 0, 30, 0, 0, 25, 0, 0
	};

	final int PAI = 3141593;
//
	public void writeShortBEtoLE(short dis) {
		int i;
		short samp;

		samp = dis;
		try { 
			for(i = 0; i < 2; i++) {
				data_out.writeByte((byte)(samp & 0xff));
				samp >>= 8;
			}
		} catch (IOException e) {
			System.err.println("IO error");
			status = 1;
		}
	}
//
	public void writeIntBEtoLE(int dis) {
		int i;
		int samp;

		samp = dis;
		try {
			for(i = 0; i < 4; i++) {
				data_out.writeByte((byte)(samp & 0xff));
				samp >>= 8;
			}
		} catch (IOException e) {
			System.err.println("IO error");
			status = 1;
		}
	}
//
	public void write_RadShortBEtoLE(short dis) {
		int i;
		short samp;

		samp = dis;
		try { 
			for(i = 0; i < 2; i++) {
				myRAFile.writeByte((byte)(samp & 0xff));
				samp >>= 8;
			}
		} catch (IOException e) {
			System.err.println("IO error");
			status = 1;
		}
	}
//
	public void write_RadIntBEtoLE(int dis) {
		int i;
		int samp;

		samp = dis;
		try {
			for(i = 0; i < 4; i++) {
				myRAFile.writeByte((byte)(samp & 0xff));
				samp >>= 8;
			}
		} catch (IOException e) {
			System.err.println("IO error");
			status = 1;
		}
	}
//
	public void output0_mtn_file() {
		int i;

		byte[] dmy = START_TAG.getBytes();
		try {
			for(i = 0; i < dmy.length; i++) {
				data_out.writeByte(dmy[i]);
			}
		} catch (IOException e) {
			System.err.println("IO error");
			status = 1;
		}
		seek_next = dmy.length;
	}
//
	public void output1_mtn_file() {
		writeIntBEtoLE(sub_tag);
		writeIntBEtoLE(24);
		writeIntBEtoLE(SUB_TAG_MAX);
		writeShortBEtoLE((short)1);
		writeShortBEtoLE((short)2);
		writeShortBEtoLE((short)2);		/* key frames */
		writeShortBEtoLE((short)16);
		writeIntBEtoLE(0);
		seek_next += 24;

	}
//
	public void output2_mtn_file() {
		int i, size, marume = 0;

		size = 11;		/* 4 + 4 + 1 + 1 + 1 */

//		String local_name = "a_";
//		switch(start_style) {
//			case 0 :
//				local_name += "sleep#sleep_";
//				break;
//			case 1 :
//				local_name += "sit#sit_";
//				break;
//			case 2 :
//				local_name += "stand#stand_";
//				break;
//		}
//		local_name += saveFileName;

		byte[] nameB = name.getBytes();
		size += nameB.length;
		byte[] createrB = creater.getBytes();
		size += createrB.length;
		byte[] designLabelB = designLabel.getBytes();
		size += designLabelB.length;
		if((size % 4) > 0) {
			marume = (4 - (size % 4));
			size += marume;
		}
		seek_next += size;

		writeIntBEtoLE(sub_tag);
		writeIntBEtoLE(size);
		try {
			data_out.writeByte(nameB.length);
			for(i = 0; i < nameB.length; i++) {
				data_out.writeByte(nameB[i]);
			}
			data_out.writeByte(createrB.length);
			for(i = 0; i < createrB.length; i++) {
				data_out.writeByte(createrB[i]);
			}
			data_out.writeByte(designLabelB.length);
			for(i = 0; i < designLabelB.length; i++) {
				data_out.writeByte(designLabelB[i]);
			}
			if(marume > 0) {
				for(i = 0; i < marume; i++) {
					data_out.writeByte((byte)0);
				}
			}
		} catch (IOException e) {
			System.err.println("IO error");
			status = 1;
		}
	}
//
	public void output3_mtn_file() {
		int i,j;

		writeIntBEtoLE(sub_tag);
		writeIntBEtoLE(504);
		writeShortBEtoLE((short)20);
		try {
			for(i = 0; i < JOINT_PRM.length; i++) {
				byte[] buf = JOINT_PRM[i].getBytes();
				data_out.writeByte(buf.length);
				for(j = 0; j < buf.length; j++) {
					data_out.writeByte(buf[j]);
				}
			}
		} catch (IOException e) {
			System.err.println("IO error");
			status = 1;
		}
		writeShortBEtoLE((short)0);
		seek_next += 504;
	}

	public void output4_1_mtn_file() {
		writeIntBEtoLE(sub_tag);
		writeIntBEtoLE(200);
		seek_next += 4;
	}

	public int output4_2_mtn_file(int length, int [] body, int [] angles) {
		int i;

		key_frames++;
		writeIntBEtoLE(length);
		for(i = 0; i < body.length; i++) {
			writeIntBEtoLE(body[i] * PAI / 180);
		}
		for(i = 0; i < angles.length; i++) {
			writeIntBEtoLE(angles[i] * PAI / 180);
		}
		return(status);
	}

	public int output_first_mtn_file() {
		output0_mtn_file();
		if(status == 0) {
			output1_mtn_file();
			if(status == 0) {
				sub_tag++;
				output2_mtn_file();
				if(status == 0) {
					sub_tag++;
					output3_mtn_file();
					if(status == 0) {
						sub_tag++;
						output4_1_mtn_file();
						if(status == 0) {
							output_base_mtn_frame(startKeyFrameLength);
						}
					}
				}
			}
		}
		return(status);
	}

	public int output_last_mtn_file() {
		output_base_mtn_frame(endKeyFrameLength);
		return(status);
	}

	public void output_base_mtn_frame(int length) {
		switch(start_style) {
			case 0 :
				output4_2_mtn_file(length, defaultKeyFrameSleepBody, defaultKeyFrameSleepAngles);
				break;
			case 1 :
				output4_2_mtn_file(length, defaultKeyFrameSitBody, defaultKeyFrameSitAngles);
				break;
			case 2 :
				output4_2_mtn_file(length, defaultKeyFrameStandBody, defaultKeyFrameStandAngles);
				break;
		}
	}

	public int open_MtnFile() {
		try { 
			file_out = new FileOutputStream(saveFileName + "." + saveFileExtension);
			data_out = new DataOutputStream(file_out);
		} catch (IOException e) {
			System.err.println("Opening/Closing error");
			status = 1;
		}
		return(status);
	}

	public int close_MtnFile() {
		try { 
			data_out.close();
			file_out.close();
		} catch (IOException e) {
			System.err.println("Opening/Closing error");
			status = 1;
		}
		return(status);
	}

	public int rewirte_key_frames() { 
		try { 
			myRAFile = new RandomAccessFile(saveFileName + "." + saveFileExtension, "rw"); 
			try { 
				myRAFile.seek(20L); 
				write_RadShortBEtoLE((short)key_frames);
				myRAFile.seek(seek_next);
				write_RadIntBEtoLE(key_frames * 96 + 8);
			} catch (IOException e) {
				System.err.println("IO error");
				status = 1;
			} finally {
				myRAFile.close();
			}
		} catch (IOException e) {
			System.err.println("Opening/Closing error");
		}
		return(status);
	}
}

