//	ShowOtherSystemValue.java
import java.awt.*;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
//import java.awt.event.ActionListener;
//import java.awt.event.ActionEvent;

/*
 *
 */
class ShowOtherSystemValue extends Frame implements WindowListener, Runnable {
	boolean frame_closing = false;

	Label dateL, weekL, timeL;

	TextField aibo_idT, traceT, debugT, auto_resetT, powerT, posture2T, temp_hiT, temp_okT, waitT, waitmodeT, clockT, int_clockT, seedT, contextT;
	TextField category_lT, category_mT, category_sT;

	SimpleCommander sc;

	String week_string[] = {
		"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", ""
	};

	public ShowOtherSystemValue(SimpleCommander id) {
		super("Other System Value");
		addWindowListener(this);
		sc = id;

		setLayout(new BorderLayout());

		Panel date_timeP = new Panel();
		date_timeP.setLayout(new GridLayout(3,1));
		date_timeP.add(dateL = new Label(""));
		date_timeP.add(weekL = new Label(""));
		date_timeP.add(timeL = new Label(""));

		Panel centerP = new Panel();
		centerP.setLayout(new GridLayout(17,2));
		centerP.add(new Label("AiboId"));
		centerP.add(aibo_idT = new TextField("0",6));
		centerP.add(new Label("Trace"));
		centerP.add(traceT = new TextField("0",6));
		centerP.add(new Label("Debug"));
		centerP.add(debugT = new TextField("0",6));
		centerP.add(new Label("AutoReset"));
		centerP.add(auto_resetT = new TextField("0",6));
		centerP.add(new Label("Power"));
		centerP.add(powerT = new TextField("0",6));
		centerP.add(new Label("Posture2"));
		centerP.add(posture2T = new TextField("0",6));
		centerP.add(new Label("Temp_Hi"));
		centerP.add(temp_hiT = new TextField("0",6));
		centerP.add(new Label("Temp_OK"));
		centerP.add(temp_okT = new TextField("0",6));
		centerP.add(new Label("Wait"));
		centerP.add(waitT = new TextField("0",6));
		centerP.add(new Label("WaitMode"));
		centerP.add(waitmodeT = new TextField("0",6));
		centerP.add(new Label("Clock"));
		centerP.add(clockT = new TextField("0",6));
		centerP.add(new Label("IntClock"));
		centerP.add(int_clockT = new TextField("0",6));
		centerP.add(new Label("Seed"));
		centerP.add(seedT = new TextField("0",6));
		centerP.add(new Label("Context"));
		centerP.add(contextT = new TextField("0",6));
		centerP.add(new Label("CategoryL"));
		centerP.add(category_lT = new TextField("0",6));
		centerP.add(new Label("CategoryM"));
		centerP.add(category_mT = new TextField("0",6));
		centerP.add(new Label("CategoryS"));
		centerP.add(category_sT = new TextField("0",6));
		aibo_idT.setEditable(false);
		traceT.setEditable(false);
		debugT.setEditable(false);
		auto_resetT.setEditable(false);
		powerT.setEditable(false);
		posture2T.setEditable(false);
		temp_hiT.setEditable(false);
		temp_okT.setEditable(false);
		waitT.setEditable(false);
		waitmodeT.setEditable(false);
		clockT.setEditable(false);
		int_clockT.setEditable(false);
		seedT.setEditable(false);
		contextT.setEditable(false);
		category_lT.setEditable(false);
		category_mT.setEditable(false);
		category_sT.setEditable(false);

		add(date_timeP, "North");
//		add(new Label("W"),"West");
//		add(new Label("E"),"East");
		add(centerP, "Center");
//		add(new Label("S"), "South"); 
	}

	public void frame_start() {
		setSize(140,400);
		setResizable(false);
		setVisible(true);
	}

	public void windowClosing(WindowEvent we) {
		this.frame_closing = true;
		dispose();
//		System.exit(1);
	}

	public void windowClosed(WindowEvent we) { }
	public void windowOpened(WindowEvent we) { }
	public void windowIconified(WindowEvent we) { }
	public void windowDeiconified(WindowEvent we) { }
	public void windowActivated(WindowEvent we) { }
	public void windowDeactivated(WindowEvent we) { }

	public void run() {
		while(true) {
			if(this.frame_closing) {
				break;
			}

			try {
				Thread.sleep(500);
			} catch (InterruptedException e) {}

			dateL.setText("Date " + sc.mem_Year + "/" + sc.mem_Month + "/" + sc.mem_Day);	//
			weekL.setText("Week " + week_string[sc.mem_Dow]);					// 
			timeL.setText("Time " + sc.mem_Hour + ":" + sc.mem_Min + ":" + sc.mem_Sec);	// 

			aibo_idT.setText("" + sc.mem_AiboId);					// 
			traceT.setText("" + sc.mem_Trace);						// 
			debugT.setText("" + sc.mem_Debug);						// 
			auto_resetT.setText("" + sc.mem_AutoReset);				// 
			powerT.setText("" + sc.mem_Power);						// 
			posture2T.setText("" + sc.mem_Posture2);				// Posture2
			temp_hiT.setText("" + sc.mem_Temp_Hi);					// 
			temp_okT.setText("" + sc.mem_Temp_OK);					// 
			waitT.setText("" + sc.mem_Wait);						// 
			waitmodeT.setText("" + sc.mem_WaitMode);				// 
			clockT.setText("" + sc.mem_Clock);						// 
			int_clockT.setText("" + sc.mem_IntClock);				// 
			seedT.setText("" + sc.mem_Seed);						// 
			contextT.setText("" + sc.mem_Context);					// 

			category_lT.setText("" + sc.mem_CategoryL);				// 
			category_mT.setText("" + sc.mem_CategoryM);				// 
			category_sT.setText("" + sc.mem_CategoryS);				// 

		}
	}
}
