//	BaseCommander.java
import java.io.*;
//import java.awt.*;

import java.net.*; 

/*
 *
 */
class BaseCommander { 
	String hostName;
	int port;
	Socket  socket = null;
	InputStream  input = null;
	OutputStream output = null;
	Thread thread = null;

	public void connect(String hostName, int port) {
		disconnect();
		try {
			Socket socket = new Socket(hostName, port);				// aibõ|[gԍ 21002 ɐڑ
			input = socket.getInputStream();						// aiboƂ̒ʐMp̓̓Xg[l
			output = socket.getOutputStream();						// aiboƂ̒ʐMp̏o̓Xg[l
		} catch (UnknownHostException e) {
			System.err.println(e.getMessage());
		} catch (IOException e) {
			System.err.println(e.getMessage());
		}
	}
//
	public void disconnect() {
		if(input != null) {
			try {
				input.close();
			} catch (IOException e) {
				System.err.println(e.getMessage());
			}
			input = null;
		}
		if(output != null) {
			try {
				output.close();
			} catch (IOException e) {
				System.err.println(e.getMessage());
			}
			output = null;
		}
		thread = null;
	}
//
	public void socketclose() {
		if(socket != null) {
			try {
				socket.close();
			} catch (IOException e) {
				System.err.println(e.getMessage());
			}
			socket = null;
		}
	}
//
	public void r_code(String str) {
		String dmy = str + "\n";
		try {
			byte[] buf = dmy.getBytes();
			if(output != null) {
				output.write(buf, 0, buf.length);
				output.flush();
			}
		} catch (IOException e) {
			System.err.println(e.getMessage());
		}
	}
}
