//	Aibo3DView.java
import java.awt.*;
import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

/*
 *
 */
class Aibo3DView extends Canvas implements MouseListener, MouseMotionListener {
	int angleHead_Tilt;												// Head_Tilt
	int angleHead_Pan;												// Head_Pan
	int angleHead_Roll;												// Head_Roll

	int angleMouth;													// Mouth

	int angleTail_Pan;												// Tail_Pan
	int angleTail_Tilt;												// Tail_Tilt

	int angleRFLeg_1;												// RFLeg_1
	int angleRFLeg_2;												// RFLeg_2
	int angleRFLeg_3;												// RFLeg_3

	int angleLFLeg_1;												// LFLeg_1
	int angleLFLeg_2;												// LFLeg_2
	int angleLFLeg_3;												// LFLeg_3

	int angleRRLeg_1;												// RRLeg_1
	int angleRRLeg_2;												// RRLeg_2
	int angleRRLeg_3;												// RRLeg_3

	int angleLRLeg_1;												// LRLeg_1
	int angleLRLeg_2;												// LRLeg_2
	int angleLRLeg_3;												// LRLeg_3

	int angleRFLeg_1_LT;
	int angleRFLeg_2_LT;
	int angleRFLeg_3_LT;

	int angleLFLeg_1_LT;
	int angleLFLeg_2_LT;
	int angleLFLeg_3_LT;

	int angleRRLeg_1_LT;
	int angleRRLeg_2_LT;
	int angleRRLeg_3_LT;

	int angleLRLeg_1_LT;
	int angleLRLeg_2_LT;
	int angleLRLeg_3_LT;

	int angleTail_Pan_LT;
	int angleTail_Tilt_LT;

	int angleHead_Tilt_LT;
	int angleHead_Pan_LT;
	int angleHead_Roll_LT;
	int angleMouth_LT;

	boolean frast_paint = false;
	boolean last_time_paint = false;

	int doX, doY;
	int angX = 320, angY = 50, angZ = 225;

	final short [][] LEG_PARAMETER = {
/* L1, L2, X0, Y0, Z0, O_Th1, O_Th2, O_Th3 */ 
		{60, 70, 59, -60, 0, -90, 0, 0},					// RFLeg
		{60, 70, 59, 60, 0, -90, 0, 0},						// LFLeg
		{60, 76, -59, -60, 0, -90, 0, 0},					// RRLeg
		{60, 76, -59, 60, 0, -90, 0, 0}						// LRLeg
	};

	final short [] TAIL_PARAMETER = {
/* L1, X0, Y0, Z0, O_Th1, O_Th2 */ 
		65, -79, 0, 40, 180, 0
	};

	final short [] HEAD_PARAMETER = {
/* L1, L2, X0, Y0, Z0, O_Th1, O_Th2 */ 
		50, 70, 73, 0, 50, 90, 0
	};

	final short [] MOUTH_PARAMETER = {
/* L1, L2, L3 */ 
		20, 25, 40
	};

	final double RAD = Math.PI / 180.0;

	Color [] col = {
		Color.gray, Color.cyan, Color.green,
		Color.red, Color.orange, Color.magenta,
		Color.blue, Color.white, Color.pink , Color.yellow
	};

	public Aibo3DView() {
		addMouseListener(this);
		addMouseMotionListener(this);
	}

	public void setLTPaint(boolean mode) {
		last_time_paint = mode;
	}

	public void mousePressed(MouseEvent e) {
		doX = e.getX();
		doY = e.getY();
	}

	public void mouseDragged(MouseEvent e) {
		angX = angX + (e.getY() - doY);
		angY = angY - (e.getX() - doX);
		doX = e.getX(); doY = e.getY();
//		System.out.println("Y = " + doX + " Z = " + doY); 
		repaint();
	}

	public void mouseClicked(MouseEvent evt) { }
	public void mouseReleased(MouseEvent evt) { }
	public void mouseEntered(MouseEvent evt) { }
	public void mouseExited(MouseEvent evt) { }

	public void mouseMoved(MouseEvent e) {}

	public void drawWF(Graphics g, double []x, double []y, double []z, int xp, int yp, Color co) {
		double z0, x1, y1, z1, x2, y2, xi, yi, zi;
		double s = 400, d = 500;
		int len = x.length;
		int [] xx = new int [len];
		int [] yy = new int [len];

		double b = angX * RAD;
		double a = angY * RAD;
		double c = angZ * RAD;	// scrZ.getValue() * RAD;
		double sinA = Math.sin(a), cosA = Math.cos(a);
		double sinB = Math.sin(b), cosB = Math.cos(b);
		double sinC = Math.sin(c), cosC = Math.cos(c);
		double zo = 0.7/*scrZ0.getValue() / 100.0*/ ;
		for(int i = 0; i < len; i++) {
			xi = x[i] * zo; yi = y[i] * zo; zi = z[i] * zo;
			z0 = -xi * sinB + zi * cosB;
			x1 = xi * cosB + zi * sinB;
			y1 = yi * cosA - z0 * sinA;
			z1 = y[i] * sinA + z0 * cosA;
			x1 = s / (d - z1) * x1;
			y1 = s / (d - z1) * y1;
			x2 = x1 * cosC - y1 * sinC;
			y2 = x1 * sinC + y1 * cosC;
			xx[i] = xp + (int)Math.rint(x2);
			yy[i] = yp - (int)Math.rint(y2);
		}
		g.setColor(co);
		g.drawPolyline(xx, yy, len);
	}

	public void drawWF_Leg(Graphics g, int position, int th1, int th2 , int th3, Color co) {
		double x0, z0, x1, z1;
		double [] x = new double[3];
		double [] y = new double[3];
		double [] z = new double[3];

		double a1, a2, a3;
		double sinA1, cosA1;
		double sinA2, cosA2;
		double sinA3, cosA3;

		switch(position) {
			default:
			case 0 :		// EOr
				a1 = (th1 + LEG_PARAMETER[position][5]) * RAD;
				a2 = (-th2 + LEG_PARAMETER[position][6]) * RAD;
				a3 = (th1 + LEG_PARAMETER[position][5] + th3 + LEG_PARAMETER[position][7]) * RAD;
				break;
			case 1 :		// Or
				a1 = (th1 + LEG_PARAMETER[position][5]) * RAD;
				a2 = (th2 + LEG_PARAMETER[position][6]) * RAD;
				a3 = (th1 + LEG_PARAMETER[position][5] + th3 + LEG_PARAMETER[position][7]) * RAD;
				break;
			case 2 :		// Er
				a1 = (-th1 + LEG_PARAMETER[position][5]) * RAD;
				a2 = (-th2 + LEG_PARAMETER[position][6]) * RAD;
				a3 = (-th1 + LEG_PARAMETER[position][5] - th3 + LEG_PARAMETER[position][7]) * RAD;
				break;
			case 3 :		// r
				a1 = (-th1 + LEG_PARAMETER[position][5]) * RAD;
				a2 = (th2 + LEG_PARAMETER[position][6]) * RAD;
				a3 = (-th1 + LEG_PARAMETER[position][5] - th3 + LEG_PARAMETER[position][7]) * RAD;
				break;
		}
		sinA1 = Math.sin(a1); cosA1 = Math.cos(a1);
		sinA2 = Math.sin(a2); cosA2 = Math.cos(a2);
		sinA3 = Math.sin(a3); cosA3 = Math.cos(a3);

		x0 = LEG_PARAMETER[position][0] * cosA1;
		z0 = LEG_PARAMETER[position][0] * sinA1;
		x1 = (LEG_PARAMETER[position][1] * cosA3 + x0);
		z1 = (LEG_PARAMETER[position][1] * sinA3 + z0);

		x[0] = LEG_PARAMETER[position][2];
		y[0] = LEG_PARAMETER[position][3];
		z[0] = LEG_PARAMETER[position][4];

		x[1] = x0 * cosA2 + LEG_PARAMETER[position][2];
		y[1] = LEG_PARAMETER[position][0] * sinA2 + LEG_PARAMETER[position][3];
		z[1] = z0 * cosA2 + LEG_PARAMETER[position][4];

		x[2] = x1 * cosA2 + LEG_PARAMETER[position][2];
		y[2] = Math.sqrt(x1 * x1 + z1 * z1) * sinA2 + LEG_PARAMETER[position][3];
		z[2] = z1 * cosA2 + LEG_PARAMETER[position][4];

		drawWF(g, x, y, z, 120, 100, co);
//		g.drawLine(angY % 360 + 20, angX % 360 + 20, 120, 120);
	}

	public void drawWF_Tail(Graphics g, int th1, int th2, Color co) {
		double x0, y0;
		double [] x = new double[2];
		double [] y = new double[2];
		double [] z = new double[2];

		double a1, a2;
		double sinA1, cosA1;
		double sinA2, cosA2;

		a1 = (th1 + TAIL_PARAMETER[4]) * RAD;
		a2 = (-th2 + TAIL_PARAMETER[5]) * RAD;
		sinA1 = Math.sin(a1); cosA1 = Math.cos(a1);
		sinA2 = Math.sin(a2); cosA2 = Math.cos(a2);

		x0 = TAIL_PARAMETER[0] * cosA1;
		y0 = TAIL_PARAMETER[0] * sinA1;

		x[0] = TAIL_PARAMETER[1];
		y[0] = TAIL_PARAMETER[2];
		z[0] = TAIL_PARAMETER[3];

		x[1] = x0 * cosA2 + TAIL_PARAMETER[1];
		y[1] = y0 + TAIL_PARAMETER[2];
		z[1] = x0 * sinA2 + TAIL_PARAMETER[3];

		drawWF(g, x, y, z, 120, 100, co);
	}

	public void drawWF_Head(Graphics g, int th1, int th2, int th3, int th4, Color co) {
		double x0, y0;
		double [] x = new double[3];
		double [] y = new double[3];
		double [] z = new double[3];

		double [] x1 = new double[2];
		double [] y1 = new double[2];
		double [] z1 = new double[2];

		double a1, a2, a3, a4, a5;
		double sinA1, cosA1;
		double sinA2, cosA2;
		double sinA3, cosA3;
		double sinA4, cosA4;
		double sinA5, cosA5;

		a1 = (th1 + HEAD_PARAMETER[5]) * RAD;
		a2 = (th2 + HEAD_PARAMETER[6]) * RAD;
		a3 = (th1) * RAD;
		a4 = (th3 - 90) * RAD;
		a5 = (th1 + HEAD_PARAMETER[5] - 180) * RAD;

		sinA1 = Math.sin(a1); cosA1 = Math.cos(a1);
		sinA2 = Math.sin(a2); cosA2 = Math.cos(a2);
		sinA3 = Math.sin(a3); cosA3 = Math.cos(a3);
		sinA4 = Math.sin(a4); cosA4 = Math.cos(a4);
		sinA5 = Math.sin(a5); cosA5 = Math.cos(a5);
		double cosA6 = Math.cos((th1 + th3 - 90) * RAD);

		x0 = HEAD_PARAMETER[1] * cosA2;
		y0 = HEAD_PARAMETER[1] * sinA2;

		x[0] = HEAD_PARAMETER[2];
		y[0] = HEAD_PARAMETER[3];
		z[0] = HEAD_PARAMETER[4];

		x[1] = HEAD_PARAMETER[0] * cosA1 + HEAD_PARAMETER[2];
		y[1] = HEAD_PARAMETER[3];
		z[1] = HEAD_PARAMETER[0] * sinA1 + HEAD_PARAMETER[4];

		x[2] = x0 * cosA3 + x[1];
		y[2] = y0 + y[1];
		z[2] = x0 * sinA3 + z[1];

		double La = MOUTH_PARAMETER[1];
		double Lb = MOUTH_PARAMETER[0];

		x1[0] = -La * cosA6 * sinA2 - La * sinA4 * cosA5 * cosA2 + Lb * cosA2 * cosA3 + x[1];
		y1[0] =  La * cosA4 * cosA2 + Lb * sinA2 + y[1];
		z1[0] = -La * sinA4 * sinA5 + Lb * cosA2 * sinA3 + z[1];

		La = MOUTH_PARAMETER[1] - MOUTH_PARAMETER[2] * Math.sin(th4 * RAD);
		Lb = MOUTH_PARAMETER[0] + MOUTH_PARAMETER[2] * Math.cos(th4 * RAD);

		x1[1] = -La * cosA6 * sinA2 - La * sinA4 * cosA5 * cosA2 + Lb * cosA2 * cosA3 + x[1];
		y1[1] =  La * cosA4 * cosA2 + Lb * sinA2 + y[1];
		z1[1] = -La * sinA4 * sinA5 + Lb * cosA2 * sinA3 + z[1];

		drawWF(g, x, y, z, 120, 100, co);
		drawWF(g, x1, y1, z1, 120, 100, co);
	}

	public void drawWF_Body(Graphics g) {
		double [] x = new double[5];
		double [] y = new double[5];
		double [] z = new double[5];

		x[0] = LEG_PARAMETER[0][2];
		y[0] = LEG_PARAMETER[0][3];
		z[0] = LEG_PARAMETER[0][4];

		x[1] = LEG_PARAMETER[1][2];
		y[1] = LEG_PARAMETER[1][3];
		z[1] = LEG_PARAMETER[1][4];

		x[2] = LEG_PARAMETER[3][2];
		y[2] = LEG_PARAMETER[3][3];
		z[2] = LEG_PARAMETER[3][4];

		x[3] = LEG_PARAMETER[2][2];
		y[3] = LEG_PARAMETER[2][3];
		z[3] = LEG_PARAMETER[2][4];

		x[4] = LEG_PARAMETER[0][2];
		y[4] = LEG_PARAMETER[0][3];
		z[4] = LEG_PARAMETER[0][4];

		drawWF(g, x, y, z, 120, 100, col[7]);

		x[0] = LEG_PARAMETER[0][2];
		y[0] = LEG_PARAMETER[0][3];
		z[0] = LEG_PARAMETER[0][4];

		x[1] = HEAD_PARAMETER[2];
		y[1] = HEAD_PARAMETER[3];
		z[1] = HEAD_PARAMETER[4];

		x[2] = TAIL_PARAMETER[1];
		y[2] = TAIL_PARAMETER[2];
		z[2] = TAIL_PARAMETER[3];

		x[3] = LEG_PARAMETER[2][2];
		y[3] = LEG_PARAMETER[2][3];
		z[3] = LEG_PARAMETER[2][4];

		x[4] = LEG_PARAMETER[0][2];
		y[4] = LEG_PARAMETER[0][3];
		z[4] = LEG_PARAMETER[0][4];

		drawWF(g, x, y, z, 120, 100, col[7]);

		x[0] = LEG_PARAMETER[1][2];
		y[0] = LEG_PARAMETER[1][3];
		z[0] = LEG_PARAMETER[1][4];

		x[1] = HEAD_PARAMETER[2];
		y[1] = HEAD_PARAMETER[3];
		z[1] = HEAD_PARAMETER[4];

		x[2] = TAIL_PARAMETER[1];
		y[2] = TAIL_PARAMETER[2];
		z[2] = TAIL_PARAMETER[3];

		x[3] = LEG_PARAMETER[3][2];
		y[3] = LEG_PARAMETER[3][3];
		z[3] = LEG_PARAMETER[3][4];

		x[4] = LEG_PARAMETER[1][2];
		y[4] = LEG_PARAMETER[1][3];
		z[4] = LEG_PARAMETER[1][4];

		drawWF(g, x, y, z, 120, 100, col[7]);
	}

	public void paint(Graphics g) {
		g.drawString("AIBO 3D View" + "  TL : " + (last_time_paint ? "On" : "Off"), 0, 10);
		g.drawString("Tilt=" + angX % 360 + " Pan=" + angY % 360, 0, getSize().height - 10);

		drawWF_Leg(g, 0, angleRFLeg_1, angleRFLeg_2, angleRFLeg_3, col[1]);
		drawWF_Leg(g, 1, angleLFLeg_1, angleLFLeg_2, angleLFLeg_3, col[2]);
		drawWF_Leg(g, 2, angleRRLeg_1, angleRRLeg_2, angleRRLeg_3, col[3]);
		drawWF_Leg(g, 3, angleLRLeg_1, angleLRLeg_2, angleLRLeg_3, col[4]);
		drawWF_Tail(g, angleTail_Pan, angleTail_Tilt, col[5]);
		drawWF_Head(g, angleHead_Tilt, angleHead_Pan, angleHead_Roll, angleMouth, col[6]);
		drawWF_Body(g);

		if(!frast_paint) {
			frast_paint = true;
		} else {
			if(last_time_paint) {
				drawWF_Leg(g, 0, angleRFLeg_1_LT, angleRFLeg_2_LT, angleRFLeg_3_LT, col[0]);
				drawWF_Leg(g, 1, angleLFLeg_1_LT, angleLFLeg_2_LT, angleLFLeg_3_LT, col[0]);
				drawWF_Leg(g, 2, angleRRLeg_1_LT, angleRRLeg_2_LT, angleRRLeg_3_LT, col[0]);
				drawWF_Leg(g, 3, angleLRLeg_1_LT, angleLRLeg_2_LT, angleLRLeg_3_LT, col[0]);
				drawWF_Tail(g, angleTail_Pan_LT, angleTail_Tilt_LT, col[0]);
				drawWF_Head(g, angleHead_Tilt_LT, angleHead_Pan_LT, angleHead_Roll_LT, angleMouth_LT, col[0]);
			}
		}
	}
}
