//	Cmd.java
import java.io.*;
import java.awt.*;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.net.*; 

class SimpleCommander { 
    String hostName;
    int port;
	Socket  socket = null;
	InputStream  input = null;
	OutputStream output = null;
//    Thread thread = null;

    public void connect(String hostName, int port) {
		disconnect();
		try {
		    Socket socket = new Socket(hostName, port);				// aibõ|[gԍ 21002 ɐڑ
		    input = socket.getInputStream();						// aiboƂ̒ʐMp̓̓Xg[l
		    output = socket.getOutputStream();						// aiboƂ̒ʐMp̏o̓Xg[l
		} catch (UnknownHostException e) {
		    System.err.println(e.getMessage());
		} catch (IOException e) {
		    System.err.println(e.getMessage());
		}
//		if(thread == null) {
//		    thread = new Thread(this);
//		}
//		thread.start();
//		observer.notifyConnection();
    }

    public void disconnect() {
		if(input != null) {
		    try {
				input.close();
		    } catch (IOException e) {
				System.err.println(e.getMessage());
		    }
		    input = null;
		}
		if(output != null) {
		    try {
				output.close();
		    } catch (IOException e) {
				System.err.println(e.getMessage());
		    }
		    output = null;
		}
//		thread = null;
//		observer.notifyConnection();
    }

    public void socketclose() {
		if(socket != null) {
		    try {
				socket.close();
		    } catch (IOException e) {
				System.err.println(e.getMessage());
		    }
		    socket = null;
		}
	}

	public void r_code(String str) {
		try {
			byte[] buf = str.getBytes();
			output.write(buf, 0, buf.length);
			output.flush();
		} catch (IOException e) {
			System.err.println(e.getMessage());
		}
	}
}


public class Cmd extends Frame implements WindowListener, ActionListener {
	Cmd m;

	TextField hostname;
	TextArea log;

	Panel connectP;
	Panel styleP;
	Panel moveP;
	Panel buttonP;
	Panel actionP;

	Button connect, disconnect;
	Button stand,sit,lie;
	Button walk,stop,back,left,right;
	Button l_walk,r_walk,l_back,r_back;

	SimpleCommander sc = new SimpleCommander();

	public Cmd() {
		super("Cmd");
		addWindowListener(this);

//
		setLayout(new BorderLayout());

		connectP = new Panel();
		connectP.setLayout(new GridLayout(2,2));

		hostname = new TextField("aibo",20);
		connect = new Button("Connect");
		disconnect = new Button("DisConnect");

		connectP.add(connect);
		connectP.add(hostname);
		connectP.add(disconnect);

		styleP = new Panel();
		styleP.setLayout(new GridLayout(3,1));

		stand = new Button("Stand");
		sit = new Button("Sit");
		lie = new Button("Lie");

		styleP.add(stand);
		styleP.add(sit);
		styleP.add(lie);

		moveP = new Panel();
		moveP.setLayout(new GridLayout(3,3));

		walk = new Button("Walk");
		stop = new Button("Stop");
		back = new Button("Back");

		left = new Button("Left");
		right = new Button("Right");
		l_walk = new Button("L_Walk");

		r_walk = new Button("R_Walk");
		l_back = new Button("L_Back");
		r_back = new Button("R_Back");

		moveP.add(l_walk);
		moveP.add(walk);
		moveP.add(r_walk);
		moveP.add(left);
		moveP.add(stop);
		moveP.add(right);
		moveP.add(l_back);
		moveP.add(back);
		moveP.add(r_back);

		actionP = new Panel();
		actionP.add(moveP);

		buttonP = new Panel();
		buttonP.add(connectP);

		log = new TextArea("Log", 5, 40); 
		log.setEditable(false);										// log ͕\[hɐݒ 

		add(buttonP, "North");
		add(styleP,"East");
		add(actionP, "Center");
        add(log, "South"); 
//
		connect.addActionListener(this);
		disconnect.addActionListener(this);
//
		stand.addActionListener(this);
		sit.addActionListener(this);
		lie.addActionListener(this);
//
		walk.addActionListener(this);
		stop.addActionListener(this);
		back.addActionListener(this);
		left.addActionListener(this);
		right.addActionListener(this);
		l_walk.addActionListener(this);
		r_walk.addActionListener(this);
		l_back.addActionListener(this);
		r_back.addActionListener(this);
//

	}

	public void start() {
		setSize(400,300);
		setVisible(true);
		SimpleCommander sc = new SimpleCommander();
	}

	public void windowClosing(WindowEvent we) {
		dispose();
		System.exit(1);
	}

	public void windowClosed(WindowEvent we) { }
	public void windowOpened(WindowEvent we) { }
	public void windowIconified(WindowEvent we) { }
	public void windowDeiconified(WindowEvent we) { }
	public void windowActivated(WindowEvent we) { }
	public void windowDeactivated(WindowEvent we) { }

	public void actionPerformed(ActionEvent ae) {
		if(connect.equals(ae.getSource())) {
			sc.connect(hostname.getText(), 21002);			// aibõ|[gԍ 21002 ɐڑAo̓Xg[J
		} else {
			if(disconnect.equals(ae.getSource())) {
				sc.disconnect();									// o̓Xg[
				sc.socketclose();									// ڑ
			} else if(stand.equals(ae.getSource())) {
				sc.r_code("PLAY:ACTION:STAND\n");					// 
			} else if(sit.equals(ae.getSource())) {
				sc.r_code("PLAY:ACTION:SIT\n");						// 
			} else if(lie.equals(ae.getSource())) {
				sc.r_code("PLAY:ACTION:LIE\n");						// 
			} else if(walk.equals(ae.getSource())) {
				sc.r_code("PLAY:ACTION:WALK:0:-1\n");				// Oi
			} else if(stop.equals(ae.getSource())) {
				sc.r_code("STOP\n");								// ~܂
			} else if(back.equals(ae.getSource())) {
				sc.r_code("PLAY:ACTION:WALK:180:-1\n");				// i
			} else if(left.equals(ae.getSource())) {
				sc.r_code("PLAY:ACTION:WALK:90:-1\n");				// Ɉړ
			} else if(right.equals(ae.getSource())) {
				sc.r_code("PLAY:ACTION:WALK:-90:-1\n");				// EɈړ
			} else if(l_walk.equals(ae.getSource())) {
				sc.r_code("PLAY:ACTION:WALK:45:-1\n");				// ΂ߑOɐi
			} else if(r_walk.equals(ae.getSource())) {
				sc.r_code("PLAY:ACTION:WALK:-45:-1\n");				// E΂ߑOɐi
			} else if(l_back.equals(ae.getSource())) {
				sc.r_code("PLAY:ACTION:WALK:135:-1\n");				// ΂ߌi
			} else if(r_back.equals(ae.getSource())) {
				sc.r_code("PLAY:ACTION:WALK:-135:-1\n");			// E΂ߌi
			}

		}
	}

	public static void main(String args[]) {
		Cmd m = new Cmd();
		m.start();
	}
}

